/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.alexandria.mixins;

import com.shiftthedev.alexandria.data.CachedEntities;
import com.shiftthedev.alexandria.items.LivingEntityItem;
import com.shiftthedev.alexandria.registry.CommonRegistry;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(method={"parse(Lnet/minecraft/core/HolderLookup$Provider;Lnet/minecraft/nbt/Tag;)Ljava/util/Optional;"}, at={@At(value="RETURN")})
    private static void parse_alexandria(HolderLookup.Provider provider, Tag tag, CallbackInfoReturnable<Optional<ItemStack>> cir) {
        ItemStack result = ((Optional)cir.getReturnValue()).orElse(ItemStack.EMPTY);
        Item item = result.getItem();
        if (item instanceof LivingEntityItem) {
            LivingEntityItem livingEntityItem = (LivingEntityItem)item;
            if (!result.has((DataComponentType)CommonRegistry.ENTITY_DATA_COMPONENT.get())) {
                CachedEntities.getCache(livingEntityItem.getKey()).updateOldStack(result, null);
            }
        }
    }
}

