/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.alexandria.mixins;

import com.shiftthedev.alexandria.events.PlayerInteractEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    @Inject(method={"interactOn(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;", shift=At.Shift.BEFORE, ordinal=0)}, cancellable=true)
    private void interact_alexandria(Entity entity, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        if (!this.level().isClientSide && interactionHand == InteractionHand.MAIN_HAND && this.getItemInHand(interactionHand).isEmpty() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (new PlayerInteractEvent(this.level(), (Player)this, livingEntity, false).invoke()) {
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
                cir.cancel();
            }
        }
    }

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }
}

