/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.alexandria.network;

import com.shiftthedev.alexandria.data.CachedEntities;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ClientUpdatePacket<T extends LivingEntity> {
    private static final CustomPacketPayload.Type<ClientUpdatePayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alexandria", (String)"update"));
    private static final StreamCodec<FriendlyByteBuf, ClientUpdatePayload> CODEC = StreamCodec.ofMember(ClientUpdatePacket::write, ClientUpdatePacket::read);

    public static void register() {
        if (Platform.getEnvironment() == Env.SERVER) {
            NetworkManager.registerS2CPayloadType(TYPE, CODEC);
        } else {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), TYPE, CODEC, ClientUpdatePacket::receive);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void receive(ClientUpdatePayload payload, NetworkManager.PacketContext context) {
        if (!context.getPlayer().isLocalPlayer()) {
            return;
        }
        UUID uuid = payload.uuid();
        CompoundTag tag = payload.tag();
        if (tag.isEmpty()) {
            CachedEntities.getCache(payload.cacheKey).receiveRemoveEntity(uuid);
            return;
        }
        CachedEntities.getCache(payload.cacheKey).receiveCachedEntity(uuid, tag, (Level)Minecraft.getInstance().level);
    }

    public static void sendToPlayer(UUID entityID, CompoundTag tag, String cacheKey, ServerPlayer player) {
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientUpdatePayload(entityID, tag, cacheKey));
    }

    private static void write(ClientUpdatePayload payload, FriendlyByteBuf buf) {
        buf.writeUUID(payload.uuid());
        buf.writeNbt((Tag)payload.tag());
        buf.writeUtf(payload.cacheKey());
    }

    private static ClientUpdatePayload read(FriendlyByteBuf buf) {
        return new ClientUpdatePayload(buf.readUUID(), buf.readNbt(), buf.readUtf());
    }

    public record ClientUpdatePayload(UUID uuid, CompoundTag tag, String cacheKey) implements CustomPacketPayload
    {
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

