/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.alexandria.network;

import com.shiftthedev.alexandria.events.PlayerInteractEvent;
import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PickupPacket<T extends LivingEntity> {
    private static final CustomPacketPayload.Type<PickupPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alexandria", (String)"input"));
    private static final StreamCodec<FriendlyByteBuf, PickupPayload> CODEC = StreamCodec.ofMember(PickupPacket::write, PickupPacket::read);

    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), TYPE, CODEC, PickupPacket::receive);
    }

    private static void receive(PickupPayload payload, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        UUID uuid = payload.uuid();
        float distance = payload.distance();
        player.level().getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate((double)distance), entity -> entity.getUUID().equals(uuid)).stream().findAny().ifPresent(entity -> new PlayerInteractEvent(player.level(), player, (LivingEntity)entity, true).invoke());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(UUID uuid, float distance) {
        NetworkManager.sendToServer((CustomPacketPayload)new PickupPayload(uuid, distance));
    }

    private static void write(PickupPayload payload, FriendlyByteBuf buf) {
        buf.writeUUID(payload.uuid());
        buf.writeFloat(payload.distance());
    }

    private static PickupPayload read(FriendlyByteBuf buf) {
        return new PickupPayload(buf.readUUID(), buf.readFloat());
    }

    public record PickupPayload(UUID uuid, float distance) implements CustomPacketPayload
    {
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

