/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.alexandria.network;

import com.shiftthedev.alexandria.data.CachedEntities;
import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class RemoveEntityPacket<T extends LivingEntity> {
    private static final CustomPacketPayload.Type<RemoveEntityPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alexandria", (String)"remove"));
    private static final StreamCodec<FriendlyByteBuf, RemoveEntityPayload> CODEC = StreamCodec.ofMember(RemoveEntityPacket::write, RemoveEntityPacket::read);

    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), TYPE, CODEC, RemoveEntityPacket::receive);
    }

    private static void receive(RemoveEntityPayload payload, NetworkManager.PacketContext context) {
        if (context.getPlayer().isLocalPlayer()) {
            return;
        }
        CachedEntities.getCache(payload.cacheKey()).uncache(payload.uuid(), null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(UUID uuid, String cacheKey) {
        NetworkManager.sendToServer((CustomPacketPayload)new RemoveEntityPayload(uuid, cacheKey));
    }

    private static void write(RemoveEntityPayload payload, FriendlyByteBuf buf) {
        buf.writeUUID(payload.uuid());
        buf.writeUtf(payload.cacheKey());
    }

    private static RemoveEntityPayload read(FriendlyByteBuf buf) {
        return new RemoveEntityPayload(buf.readUUID(), buf.readUtf());
    }

    public record RemoveEntityPayload(UUID uuid, String cacheKey) implements CustomPacketPayload
    {
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

