/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.alexandria.network;

import com.shiftthedev.alexandria.data.CachedEntities;
import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class RequestUpdatePacket<T extends LivingEntity> {
    private static final CustomPacketPayload.Type<RequestUpdatePayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alexandria", (String)"request"));
    private static final StreamCodec<FriendlyByteBuf, RequestUpdatePayload> CODEC = StreamCodec.ofMember(RequestUpdatePacket::write, RequestUpdatePacket::read);

    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), TYPE, CODEC, RequestUpdatePacket::receive);
    }

    private static void receive(RequestUpdatePayload payload, NetworkManager.PacketContext context) {
        if (context.getPlayer().isLocalPlayer()) {
            return;
        }
        CachedEntities.getCache(payload.cacheKey).sendCachedEntity((ServerPlayer)context.getPlayer(), payload.uuid());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(UUID uuid, String cacheKey) {
        NetworkManager.sendToServer((CustomPacketPayload)new RequestUpdatePayload(uuid, cacheKey));
    }

    private static void write(RequestUpdatePayload payload, FriendlyByteBuf buf) {
        buf.writeUUID(payload.uuid());
        buf.writeUtf(payload.cacheKey());
    }

    private static RequestUpdatePayload read(FriendlyByteBuf buf) {
        return new RequestUpdatePayload(buf.readUUID(), buf.readUtf());
    }

    public record RequestUpdatePayload(UUID uuid, String cacheKey) implements CustomPacketPayload
    {
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

