/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.alexandria.registry;

import com.shiftthedev.alexandria.data.EntityDataComponent;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CommonRegistry {
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((String)"alexandria", (ResourceKey)Registries.CREATIVE_MODE_TAB);
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"alexandria", (ResourceKey)Registries.ITEM);
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.create((String)"alexandria", (ResourceKey)Registries.DATA_COMPONENT_TYPE);
    private static final RegistrySupplier<Item> ICON = CommonRegistry.createItem("alexandria", "icon", () -> new Item(new Item.Properties().stacksTo(1)));
    public static final RegistrySupplier<CreativeModeTab> TAB = TABS.register("alexandria_tab", () -> CreativeTabRegistry.create((Component)Component.translatable((String)"itemGroup.alexandria.tab"), () -> new ItemStack((ItemLike)ICON.get())));
    public static final RegistrySupplier<DataComponentType<EntityDataComponent>> ENTITY_DATA_COMPONENT = DATA_COMPONENT_TYPES.register("entity_custom_data", () -> DataComponentType.builder().persistent(EntityDataComponent.CODEC).networkSynchronized(EntityDataComponent.STREAM_CODEC).build());

    public static void register() {
        TABS.register();
        ITEMS.register();
        DATA_COMPONENT_TYPES.register();
    }

    public static RegistrySupplier<Item> createItem(String modId, String id, Supplier<Item> itemSupplier) {
        return ITEMS.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)id), itemSupplier);
    }
}

