/*
 * Decompiled with CFR 0.152.
 */
package com.mmmmm;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mmmmm.Config;
import com.mmmmm.MMMMM;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class RegisterCommands {
    private static FileTime lastBuildTime = FileTime.fromMillis(0L);
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final Map<String, Boolean> modrinthCache = new HashMap<String, Boolean>();
    private static final HttpClient httpClient = HttpClient.newHttpClient();

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"mmmmm").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"save-mods").requires(source -> source.method_9259(2))).executes(RegisterCommands::saveModsToZip))));
    }

    public static int saveModsToZip(CommandContext<class_2168> context) {
        executor.execute(() -> {
            Path modsFolder = Path.of("mods", new String[0]);
            Path modsZip = Path.of("MMMMM/shared-files/mods.zip", new String[0]);
            try {
                List modFiles = Files.walk(modsFolder, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith(".jar")).collect(Collectors.toList());
                if (modFiles.isEmpty()) {
                    MMMMM.LOGGER.warn("No .jar files found in mods folder, skipping zip.");
                    return;
                }
                FileTime latestChange = modFiles.stream().map(path -> {
                    try {
                        return Files.getLastModifiedTime(path, new LinkOption[0]);
                    }
                    catch (IOException e) {
                        return FileTime.fromMillis(0L);
                    }
                }).max(FileTime::compareTo).orElse(FileTime.fromMillis(0L));
                if (latestChange.compareTo(lastBuildTime) <= 0 && Files.exists(modsZip, new LinkOption[0])) {
                    MMMMM.LOGGER.info("Mods have not changed since last build. Skipping zip creation.");
                    return;
                }
                MMMMM.LOGGER.info("Starting mods.zip creation. Found {} mods.", (Object)modFiles.size());
                try (ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(modsZip, new OpenOption[0]));){
                    int total = modFiles.size();
                    int index = 0;
                    for (Path path2 : modFiles) {
                        ++index;
                        try {
                            String modId = RegisterCommands.getModIdFromJar(path2);
                            String modName = RegisterCommands.getModNameFromJar(path2);
                            if (modId != null) {
                                boolean exclude;
                                boolean bl = exclude = Config.filterServerSideMods && RegisterCommands.isServerOnlyMod(modId, modName);
                                if (!exclude) {
                                    Path relativePath = modsFolder.relativize(path2);
                                    ZipEntry zipEntry = new ZipEntry(relativePath.toString());
                                    zipOut.putNextEntry(zipEntry);
                                    Files.copy(path2, zipOut);
                                    zipOut.closeEntry();
                                    MMMMM.LOGGER.info("[{}/{}] Included mod: {} ({})", new Object[]{index, total, modName != null ? modName : modId, path2.getFileName()});
                                    continue;
                                }
                                MMMMM.LOGGER.info("[{}/{}] Excluded server-only mod: {} ({})", new Object[]{index, total, modName != null ? modName : modId, path2.getFileName()});
                                continue;
                            }
                            MMMMM.LOGGER.warn("[{}/{}] Could not identify mod: {}", new Object[]{index, total, path2.getFileName()});
                        }
                        catch (Exception e) {
                            MMMMM.LOGGER.error("Failed to process mod: " + String.valueOf(path2), (Throwable)e);
                        }
                    }
                }
                lastBuildTime = latestChange;
                MMMMM.LOGGER.info("Finished creating mods.zip in shared-files. {} mods processed.", (Object)modFiles.size());
            }
            catch (IOException e) {
                MMMMM.LOGGER.error("Failed to create mods.zip", (Throwable)e);
            }
        });
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Started mods.zip creation."), false);
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getModIdFromJar(Path jarPath) {
        try (FileSystem fs = FileSystems.newFileSystem(jarPath, (ClassLoader)null);){
            Path modJson = fs.getPath("fabric.mod.json", new String[0]);
            if (!Files.exists(modJson, new LinkOption[0])) return null;
            String json = Files.readString(modJson);
            JsonObject obj = JsonParser.parseString((String)json).getAsJsonObject();
            if (!obj.has("id")) return null;
            String string = obj.get("id").getAsString();
            return string;
        }
        catch (Exception e) {
            MMMMM.LOGGER.error("Failed to read mod id from: " + String.valueOf(jarPath), (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getModNameFromJar(Path jarPath) {
        try (FileSystem fs = FileSystems.newFileSystem(jarPath, (ClassLoader)null);){
            Path modJson = fs.getPath("fabric.mod.json", new String[0]);
            if (!Files.exists(modJson, new LinkOption[0])) return null;
            String json = Files.readString(modJson);
            JsonObject obj = JsonParser.parseString((String)json).getAsJsonObject();
            if (!obj.has("name")) return null;
            MMMMM.LOGGER.info("Found mod name: {}", (Object)obj.get("name").getAsString());
            String string = obj.get("name").getAsString();
            return string;
        }
        catch (Exception e) {
            MMMMM.LOGGER.error("Failed to read mod name from: " + String.valueOf(jarPath), (Throwable)e);
        }
        return null;
    }

    private static boolean isServerOnlyMod(String modId, String modName) {
        if (modrinthCache.containsKey(modId)) {
            return modrinthCache.get(modId);
        }
        boolean result = false;
        try {
            result = RegisterCommands.checkModrinthServerOnly(modId, modId, modName);
            if (!result && modName != null && !modName.isBlank()) {
                result = RegisterCommands.checkModrinthServerOnly(modName, modId, modName);
            }
        }
        catch (Exception e) {
            MMMMM.LOGGER.error("Failed to query Modrinth for: " + modId, (Throwable)e);
        }
        modrinthCache.put(modId, result);
        return result;
    }

    private static boolean checkModrinthServerOnly(String query, String modId, String modName) throws Exception {
        String facets = URLEncoder.encode("[[\"project_type:mod\"]]", "UTF-8");
        String url = "https://api.modrinth.com/v2/search?query=" + URLEncoder.encode(query, "UTF-8") + "&facets=" + facets + "&index=downloads&limit=5";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("User-Agent", "Place-Boy/https://github.com/Place-Boy/MMMMM/1.0.1-beta").GET().build();
        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        JsonObject json = JsonParser.parseString((String)response.body()).getAsJsonObject();
        JsonArray hits = json.getAsJsonArray("hits");
        if (hits != null && hits.size() > 0) {
            for (int i = 0; i < hits.size(); ++i) {
                String title;
                JsonObject mod = hits.get(i).getAsJsonObject();
                String slug = mod.has("slug") ? mod.get("slug").getAsString() : "";
                String projectId = mod.has("project_id") ? mod.get("project_id").getAsString() : "";
                String string = title = mod.has("title") ? mod.get("title").getAsString() : "";
                if (!slug.equalsIgnoreCase(modId) && !slug.equalsIgnoreCase(modName) && !projectId.equalsIgnoreCase(modId) && !title.equalsIgnoreCase(modName)) continue;
                String clientSide = mod.has("client_side") ? mod.get("client_side").getAsString() : "required";
                String serverSide = mod.has("server_side") ? mod.get("server_side").getAsString() : "required";
                return "unsupported".equalsIgnoreCase(clientSide) && "required".equalsIgnoreCase(serverSide);
            }
        }
        return false;
    }
}

