/*
 * Decompiled with CFR 0.152.
 */
package com.mmmmm.server;

import com.mmmmm.Config;
import com.mmmmm.MMMMM;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executors;

public class FileHostingServer {
    private static HttpServer fileHostingServer;
    public static final int FILE_SERVER_PORT;
    public static final Path FILE_DIRECTORY;

    public static void start() throws IOException {
        if (!Files.exists(FILE_DIRECTORY, new LinkOption[0])) {
            Files.createDirectories(FILE_DIRECTORY, new FileAttribute[0]);
        }
        fileHostingServer = HttpServer.create(new InetSocketAddress(FILE_SERVER_PORT), 0);
        fileHostingServer.createContext("/", exchange -> {
            try {
                String requestPath = exchange.getRequestURI().getPath();
                MMMMM.LOGGER.info("Received request: " + requestPath);
                Path filePath = FILE_DIRECTORY.resolve(requestPath.substring(1)).normalize();
                if (!filePath.startsWith(FILE_DIRECTORY)) {
                    MMMMM.LOGGER.warn("Unauthorized access attempt: " + String.valueOf(filePath));
                    exchange.sendResponseHeaders(403, -1L);
                    return;
                }
                if (!Files.exists(filePath, new LinkOption[0]) || Files.isDirectory(filePath, new LinkOption[0])) {
                    MMMMM.LOGGER.warn("File not found: " + String.valueOf(filePath));
                    exchange.sendResponseHeaders(404, -1L);
                    return;
                }
                String contentType = requestPath.endsWith(".zip") ? "application/zip" : "application/octet-stream";
                exchange.getResponseHeaders().add("Content-Type", contentType);
                byte[] fileBytes = Files.readAllBytes(filePath);
                exchange.sendResponseHeaders(200, fileBytes.length);
                exchange.getResponseBody().write(fileBytes);
                MMMMM.LOGGER.info("Successfully served file: " + String.valueOf(filePath));
            }
            catch (Exception e) {
                MMMMM.LOGGER.error("Error processing request", (Throwable)e);
                try {
                    exchange.sendResponseHeaders(500, -1L);
                }
                catch (IOException ioException) {
                    MMMMM.LOGGER.error("Failed to send error response", (Throwable)ioException);
                }
            }
            finally {
                exchange.close();
            }
        });
        fileHostingServer.setExecutor(Executors.newCachedThreadPool());
        new Thread(() -> {
            fileHostingServer.start();
            MMMMM.LOGGER.info("File hosting server started on port " + FILE_SERVER_PORT);
        }).start();
    }

    public static void stop() {
        if (fileHostingServer != null) {
            fileHostingServer.stop(0);
            MMMMM.LOGGER.info("File hosting server stopped.");
        }
    }

    static {
        FILE_SERVER_PORT = Config.fileServerPort;
        FILE_DIRECTORY = Path.of("MMMMM/shared-files", new String[0]);
    }
}

