/*
 * Decompiled with CFR 0.152.
 */
package com.mmmmm;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mmmmm.Config;
import com.moandjiezana.toml.Toml;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterCommands {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisterCommands.class);

    public static void onRegisterCommands(RegisterCommandsEvent event) {
        LOGGER.info("Registering server commands...");
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"mmmmm").then(((LiteralArgumentBuilder)Commands.literal((String)"save-mods").requires(source -> source.hasPermission(2))).executes(context -> {
            RegisterCommands.saveModsToZip();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Mods have been saved to mods.zip in the shared-files directory."), true);
            return 1;
        })));
    }

    public static void saveModsToZip() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            Path modsFolder = Path.of("mods", new String[0]);
            Path modsZip = Path.of("MMMMM/shared-files/mods.zip", new String[0]);
            HttpClient httpClient = HttpClient.newHttpClient();
            ArrayList includedMods = new ArrayList();
            ArrayList excludedMods = new ArrayList();
            try {
                try (ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(modsZip, new OpenOption[0]));){
                    Files.walk(modsFolder, new FileVisitOption[0]).forEach(path -> {
                        try {
                            String modName;
                            if (Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".jar") && (modName = RegisterCommands.getModNameFromJar(path)) != null) {
                                boolean isServerOnly = RegisterCommands.isServerOnlyMod(modName, httpClient);
                                if (!Config.filterServerSideMods || !isServerOnly) {
                                    Path relativePath = modsFolder.relativize((Path)path);
                                    ZipEntry zipEntry = new ZipEntry(relativePath.toString());
                                    zipOut.putNextEntry(zipEntry);
                                    Files.copy(path, zipOut);
                                    zipOut.closeEntry();
                                    includedMods.add(modName + " (" + String.valueOf(path.getFileName()) + ")");
                                } else {
                                    excludedMods.add(modName + " (" + String.valueOf(path.getFileName()) + ")");
                                }
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to process mod: " + String.valueOf(path), (Throwable)e);
                        }
                    });
                    LOGGER.info("Successfully created mods.zip in shared-files.");
                }
                LOGGER.info("Included mods: {}", (Object)(includedMods.isEmpty() ? "None" : String.join((CharSequence)", ", includedMods)));
            }
            catch (IOException e) {
                try {
                    LOGGER.error("Failed to create mods.zip", (Throwable)e);
                    LOGGER.info("Included mods: {}", (Object)(includedMods.isEmpty() ? "None" : String.join((CharSequence)", ", includedMods)));
                }
                catch (Throwable throwable) {
                    LOGGER.info("Included mods: {}", (Object)(includedMods.isEmpty() ? "None" : String.join((CharSequence)", ", includedMods)));
                    LOGGER.info("Excluded mods: {}", (Object)(excludedMods.isEmpty() ? "None" : String.join((CharSequence)", ", excludedMods)));
                    executor.shutdown();
                    throw throwable;
                }
                LOGGER.info("Excluded mods: {}", (Object)(excludedMods.isEmpty() ? "None" : String.join((CharSequence)", ", excludedMods)));
                executor.shutdown();
            }
            LOGGER.info("Excluded mods: {}", (Object)(excludedMods.isEmpty() ? "None" : String.join((CharSequence)", ", excludedMods)));
            executor.shutdown();
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getModNameFromJar(Path jarPath) {
        try (ZipFile zipFile = new ZipFile(jarPath.toFile());){
            ZipEntry entry = zipFile.getEntry("META-INF/neoforge.mods.toml");
            if (entry == null) return null;
            try (InputStream is = zipFile.getInputStream(entry);){
                Toml toml = new Toml().read(is);
                String rootDisplayName = toml.getString("display_name");
                if (rootDisplayName != null) {
                    String string = rootDisplayName;
                    return string;
                }
                List modsList = toml.getTables("mods");
                if (modsList == null) return null;
                if (modsList.isEmpty()) return null;
                Toml firstMod = (Toml)modsList.get(0);
                String modDisplayName = firstMod.getString("displayName");
                if (modDisplayName == null) return null;
                LOGGER.info("Found mod name: " + modDisplayName);
                String string = modDisplayName;
                return string;
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read toml from: " + String.valueOf(jarPath), (Throwable)e);
        }
        return null;
    }

    private static boolean isServerOnlyMod(String modName, HttpClient httpClient) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.modrinth.com/v2/search?query=" + URLEncoder.encode(modName, "UTF-8"))).header("User-Agent", "Place-Boy/https://github.com/Place-Boy/MMMMM/1.0.1-beta").GET().build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            JsonObject json = JsonParser.parseString((String)response.body()).getAsJsonObject();
            JsonArray hits = json.getAsJsonArray("hits");
            if (hits != null && hits.size() > 0) {
                JsonObject mod = hits.get(0).getAsJsonObject();
                String clientSide = mod.has("client_side") ? mod.get("client_side").getAsString() : "required";
                String serverSide = mod.has("server_side") ? mod.get("server_side").getAsString() : "required";
                return "unsupported".equalsIgnoreCase(clientSide) && "required".equalsIgnoreCase(serverSide);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to query Modrinth for: " + modName, (Throwable)e);
        }
        return false;
    }
}

