/*
 * Decompiled with CFR 0.152.
 */
package com.mmmmm.client;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;

public class DownloadProgressScreen
extends Screen {
    private final String serverUpdateIP;
    private int progress = 0;
    private String downloadSpeed = "0 KB/s";
    private Button cancelButton;
    private volatile boolean isCancelled = false;

    public DownloadProgressScreen(String serverIP) {
        super((Component)Component.literal((String)"Downloading Mods"));
        this.serverUpdateIP = serverIP;
    }

    protected void init() {
        super.init();
        int buttonWidth = 100;
        int buttonHeight = 20;
        int buttonX = (this.width - buttonWidth) / 2;
        int buttonY = this.height / 2 + 50;
        this.cancelButton = Button.builder((Component)Component.literal((String)"Cancel"), button -> {
            this.isCancelled = true;
            this.minecraft.execute(() -> this.minecraft.setScreen((Screen)new TitleScreen()));
        }).bounds(buttonX, buttonY, buttonWidth, buttonHeight).build();
        this.addRenderableWidget((GuiEventListener)this.cancelButton);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, "Downloading mods from " + this.serverUpdateIP, this.width / 2, 20, -1);
        int barWidth = 200;
        int barHeight = 20;
        int barX = (this.width - barWidth) / 2;
        int barY = this.height / 2;
        guiGraphics.drawCenteredString(this.font, this.downloadSpeed, this.width / 2, barY - 30, -1);
        guiGraphics.fill(barX, barY, barX + barWidth, barY + barHeight, -5592406);
        int progressWidth = (int)((double)barWidth * ((double)this.progress / 100.0));
        guiGraphics.fill(barX, barY, barX + progressWidth, barY + barHeight, -16711936);
        guiGraphics.drawCenteredString(this.font, this.progress + "%", this.width / 2, barY + 5, -1);
    }

    public void updateProgress(int progress, String downloadSpeed) {
        this.progress = Math.min(100, Math.max(0, progress));
        this.downloadSpeed = downloadSpeed;
    }
}

