/*
 * Decompiled with CFR 0.152.
 */
package com.mmmmm.mixin;

import com.mmmmm.client.ServerMetadata;
import com.mmmmm.mixin.EditServerScreenAccessor;
import com.mmmmm.mixin.ScreenAccessorMixin;
import com.mojang.text2speech.Narrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.EditServerScreen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EditServerScreen.class})
public abstract class EditServerScreenMixin {
    private int[] labelYPositions = new int[2];
    private EditBox customField;

    @Shadow
    public abstract void onClose();

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo ci) {
        Minecraft mc = Minecraft.getInstance();
        EditServerScreen screen = (EditServerScreen)this;
        int[] index = new int[]{0};
        screen.children().stream().filter(c -> c instanceof EditBox).map(c -> (EditBox)c).forEach(editBox -> {
            editBox.setY(editBox.getY() - 30);
            if (index[0] < 2) {
                int n = index[0];
                index[0] = n + 1;
                this.labelYPositions[n] = editBox.getY() - 10;
            }
        });
        screen.children().stream().filter(c -> c instanceof CycleButton).map(c -> (CycleButton)c).filter(button -> button.getMessage().getString().contains("Resource")).forEach(button -> button.setY(button.getY() + 18));
        this.customField = new EditBox(mc.font, mc.getWindow().getGuiScaledWidth() / 2 - 100, mc.getWindow().getGuiScaledHeight() / 4 + 60, 200, 20, (Component)Component.literal((String)"Custom Field"));
        this.customField.setMaxLength(100);
        EditServerScreenAccessor accessor = (EditServerScreenAccessor)screen;
        String serverIP = accessor.getServerData().ip;
        String existingMetadata = ServerMetadata.getMetadata(serverIP);
        if (!existingMetadata.isBlank()) {
            this.customField.setValue(existingMetadata);
        }
        ((ScreenAccessorMixin)((Object)this)).invokeAddRenderableWidget(this.customField);
    }

    @Inject(method={"onAdd"}, at={@At(value="TAIL")})
    private void onSaveCustomField(CallbackInfo ci) {
        Narrator.LOGGER.info("onSaveCustomField called");
        if (this.customField != null) {
            String customValue = this.customField.getValue();
            EditServerScreen screen = (EditServerScreen)this;
            String serverIP = ((EditServerScreenAccessor)screen).getServerData().ip;
            ServerMetadata.setMetadata(serverIP, customValue);
        }
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;III)V"))
    private void redirectDrawString(GuiGraphics graphics, Font font, Component text, int x, int y, int color) {
        String labelText = text.getString();
        if (!labelText.equals("Server Name") && !labelText.equals("Server Address")) {
            graphics.drawString(font, text, x, y, color);
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(GuiGraphics graphics, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        int x = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 - 100;
        graphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"Server Name"), x, this.labelYPositions[0], -1);
        graphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"Server Address"), x, this.labelYPositions[1], -1);
        graphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"Download URL"), x, Minecraft.getInstance().getWindow().getGuiScaledHeight() / 4 + 50, -1);
    }
}

