/*
 * Decompiled with CFR 0.152.
 */
package com.mmmmm.mixin;

import com.mmmmm.MMMMM;
import com.mmmmm.client.ClientEventHandlers;
import com.mmmmm.client.ServerMetadata;
import com.mmmmm.mixin.ScreenAccessorMixin;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={JoinMultiplayerScreen.class})
public class JoinMultiplayerScreenMixin {
    @Inject(method={"init"}, at={@At(value="HEAD")})
    private void onInit(CallbackInfo ci) {
        int yOffset;
        JoinMultiplayerScreen screen = (JoinMultiplayerScreen)this;
        ServerList serverList = new ServerList(Minecraft.getInstance());
        serverList.load();
        int buttonX = screen.width - 55;
        int buttonY = 40;
        int buttonSpacing = 35;
        int maxHeight = screen.height - 50;
        ArrayList<Button> buttonsToAdd = new ArrayList<Button>();
        for (int i = 0; i < serverList.size() && (yOffset = buttonY + i * buttonSpacing) + 20 <= maxHeight; ++i) {
            ServerData server = serverList.get(i);
            Button serverButton = this.createServerButton(buttonX, yOffset, server);
            buttonsToAdd.add(serverButton);
        }
        Minecraft.getInstance().execute(() -> {
            for (Button button : buttonsToAdd) {
                ((ScreenAccessorMixin)screen).invokeAddRenderableWidget(button);
            }
        });
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(GuiGraphics graphics, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        JoinMultiplayerScreen screen = (JoinMultiplayerScreen)this;
        for (Button button : screen.children().stream().filter(c -> c instanceof Button).map(c -> (Button)c).toList()) {
            button.render(graphics, mouseX, mouseY, delta);
        }
    }

    private Button createServerButton(int x, int y, ServerData server) {
        return Button.builder((Component)Component.literal((String)"Update"), btn -> {
            String downloadIP = ServerMetadata.getMetadata(server.ip);
            if (downloadIP == null || downloadIP.isBlank()) {
                MMMMM.LOGGER.error("No download IP found for server: {}", (Object)server.ip);
                return;
            }
            ClientEventHandlers.downloadAndProcessMod(downloadIP);
        }).bounds(x, y, 50, 20).build();
    }
}

