/*
 * Decompiled with CFR 0.152.
 */
package com.mmmmm;

import com.google.gson.Gson;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.Map;
import java.util.stream.Collectors;

public class Checksum {
    public static String computeChecksum(Path filePath) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] fileBytes = Files.readAllBytes(filePath);
        byte[] hashBytes = digest.digest(fileBytes);
        return HexFormat.of().formatHex(hashBytes);
    }

    public static void saveChecksums(Path modsDirectory, Path checksumFile) throws Exception {
        Map<String, String> checksums = Files.list(modsDirectory).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toMap(path -> path.getFileName().toString(), path -> {
            try {
                return Checksum.computeChecksum(path);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        Files.writeString(checksumFile, (CharSequence)new Gson().toJson(checksums), new OpenOption[0]);
    }

    public static void compareChecksums(Path modsDirectory, Path checksumFile) throws Exception {
        Map oldChecksums = (Map)new Gson().fromJson(Files.readString(checksumFile), Map.class);
        Map<String, String> newChecksums = Files.list(modsDirectory).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toMap(path -> path.getFileName().toString(), path -> {
            try {
                return Checksum.computeChecksum(path);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        for (String mod : newChecksums.keySet()) {
            if (!oldChecksums.containsKey(mod)) {
                System.out.println("Added: " + mod);
                continue;
            }
            if (newChecksums.get(mod).equals(oldChecksums.get(mod))) continue;
            System.out.println("Modified: " + mod);
        }
        for (String mod : oldChecksums.keySet()) {
            if (newChecksums.containsKey(mod)) continue;
            System.out.println("Removed: " + mod);
        }
    }
}

