/*
 * Decompiled with CFR 0.152.
 */
package com.mmmmm;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Checksum {
    public static String computeChecksum(Path filePath) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (InputStream in = Files.newInputStream(filePath, new OpenOption[0]);
             DigestInputStream dis = new DigestInputStream(in, digest);){
            byte[] buffer = new byte[8192];
            while (dis.read(buffer) != -1) {
            }
        }
        byte[] hashBytes = digest.digest();
        return HexFormat.of().formatHex(hashBytes);
    }

    public static void saveChecksums(Path modsDirectory, Path checksumFile) throws Exception {
        try (Stream<Path> stream = Files.list(modsDirectory);){
            Map checksums = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted().collect(Collectors.toMap(path -> path.getFileName().toString(), path -> {
                try {
                    return Checksum.computeChecksum(path);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, (a, b) -> a, LinkedHashMap::new));
            Files.createDirectories(checksumFile.getParent(), new FileAttribute[0]);
            Files.writeString(checksumFile, (CharSequence)new Gson().toJson((Object)checksums), new OpenOption[0]);
        }
    }

    public static void compareChecksums(Path modsDirectory, Path checksumFile) throws Exception {
        Map newChecksums;
        Map oldChecksums;
        Gson gson = new Gson();
        Type mapType = new TypeToken<Map<String, String>>(){}.getType();
        if (!Files.exists(checksumFile, new LinkOption[0])) {
            System.out.println("Checksum file does not exist: " + String.valueOf(checksumFile) + " \u2014 treating all files as added.");
            oldChecksums = Map.of();
        } else {
            String json = Files.readString(checksumFile);
            oldChecksums = (Map)gson.fromJson(json, mapType);
            if (oldChecksums == null) {
                oldChecksums = Map.of();
            }
        }
        try (Stream<Path> stream = Files.list(modsDirectory);){
            newChecksums = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted().collect(Collectors.toMap(path -> path.getFileName().toString(), path -> {
                try {
                    return Checksum.computeChecksum(path);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, (a, b) -> a, LinkedHashMap::new));
        }
        boolean any = false;
        for (String mod : newChecksums.keySet()) {
            if (!oldChecksums.containsKey(mod)) {
                System.out.println("Added: " + mod);
                any = true;
                continue;
            }
            if (((String)newChecksums.get(mod)).equals(oldChecksums.get(mod))) continue;
            System.out.println("Modified: " + mod);
            any = true;
        }
        for (String mod : oldChecksums.keySet()) {
            if (newChecksums.containsKey(mod)) continue;
            System.out.println("Removed: " + mod);
            any = true;
        }
        if (!any) {
            System.out.println("No changes detected.");
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: Checksum compute|save|compare ...");
            System.exit(2);
        }
        try {
            String cmd;
            switch (cmd = args[0]) {
                case "compute": {
                    if (args.length != 2) {
                        throw new IllegalArgumentException("compute requires <file>");
                    }
                    Path file = Path.of(args[1], new String[0]);
                    System.out.println(Checksum.computeChecksum(file));
                    break;
                }
                case "save": {
                    if (args.length != 3) {
                        throw new IllegalArgumentException("save requires <modsDir> <checksumFile>");
                    }
                    Path dir = Path.of(args[1], new String[0]);
                    Path out = Path.of(args[2], new String[0]);
                    Checksum.saveChecksums(dir, out);
                    System.out.println("Saved checksums to " + String.valueOf(out));
                    break;
                }
                case "compare": {
                    if (args.length != 3) {
                        throw new IllegalArgumentException("compare requires <modsDir> <checksumFile>");
                    }
                    Path dir = Path.of(args[1], new String[0]);
                    Path in = Path.of(args[2], new String[0]);
                    Checksum.compareChecksums(dir, in);
                    break;
                }
                default: {
                    System.err.println("Unknown command: " + cmd);
                    System.exit(2);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

