/*
 * Decompiled with CFR 0.152.
 */
package com.mmmmm.client;

import com.mmmmm.Checksum;
import com.mmmmm.client.DownloadProgressScreen;
import com.mmmmm.client.ServerMetadata;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_642;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ClientEventHandlers
implements ClientModInitializer {
    private static final int CONNECTION_TIMEOUT_MS = 5000;
    private static final Path MOD_DOWNLOAD_PATH = Path.of("MMMMM/shared-files/mods.zip", new String[0]);
    private static final Path UNZIP_DESTINATION = Path.of("mods", new String[0]);
    private static final Path CHECKSUM_FILE = Path.of("MMMMM/mods_checksums.json", new String[0]);
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientEventHandlers.class);
    private static class_437 lastScreen = null;
    private static final Set<String> extractedModFiles = Collections.synchronizedSet(new HashSet());

    public void onInitializeClient() {
        new Thread(() -> {
            while (true) {
                class_500 screen;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                class_310 client = class_310.method_1551();
                class_437 current = client.field_1755;
                if (current instanceof class_500 && lastScreen != (screen = (class_500)current)) {
                    lastScreen = screen;
                    continue;
                }
                if (current instanceof class_500) continue;
                lastScreen = null;
            }
        }, "mmmmm-multiplayer-poll").start();
    }

    private static class_4185 createServerButton(int x, int y, class_642 server) {
        return class_4185.method_46430((class_2561)class_2561.method_43470((String)"Update"), btn -> {
            String serverUpdateIP = ServerMetadata.getMetadata(server.field_3761);
            LOGGER.info("Update button clicked for server: {}", (Object)serverUpdateIP);
            ClientEventHandlers.downloadAndProcessMod(serverUpdateIP);
        }).method_46434(x, y, 50, 20).method_46431();
    }

    public static void downloadAndProcessMod(String serverUpdateIP) {
        Object httpUrl;
        Object httpsUrl;
        class_310 minecraft = class_310.method_1551();
        class_442 titleScreen = new class_442();
        Object modsUrl = serverUpdateIP;
        if (modsUrl == null || ((String)modsUrl).isBlank()) {
            LOGGER.info("No mod URL found for " + serverUpdateIP);
            return;
        }
        if (((String)modsUrl).startsWith("http://") || ((String)modsUrl).startsWith("https://")) {
            if (!((String)modsUrl).endsWith("/mods.zip")) {
                modsUrl = (String)modsUrl + "/mods.zip";
            }
            httpsUrl = ((String)modsUrl).startsWith("https://") ? modsUrl : null;
            httpUrl = ((String)modsUrl).startsWith("http://") ? modsUrl : null;
        } else {
            httpsUrl = "https://" + (String)modsUrl + "/mods.zip";
            httpUrl = "http://" + (String)modsUrl + "/mods.zip";
        }
        DownloadProgressScreen progressScreen = new DownloadProgressScreen((String)modsUrl);
        minecraft.method_1507((class_437)progressScreen);
        Executors.newSingleThreadExecutor().execute(() -> ClientEventHandlers.lambda$downloadAndProcessMod$3((String)httpsUrl, (String)httpUrl, progressScreen, serverUpdateIP, minecraft, titleScreen));
    }

    private static HttpURLConnection initializeConnection(String url) throws IOException {
        URL downloadUrl = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)downloadUrl.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestMethod("GET");
        int responseCode = connection.getResponseCode();
        LOGGER.info("Connecting to {} - Response Code: {}", (Object)url, (Object)responseCode);
        if (responseCode != 200) {
            throw new IOException("Failed to fetch mods - Server returned response code: " + responseCode);
        }
        return connection;
    }

    private static void downloadFileWithProgress(HttpURLConnection connection, Path destination, DownloadProgressScreen progressScreen) throws IOException {
        Path temp;
        block26: {
            temp = destination.resolveSibling(destination.getFileName().toString() + ".downloading");
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
            try (InputStream in = connection.getInputStream();
                 OutputStream out = Files.newOutputStream(temp, new OpenOption[0]);){
                int bytesRead;
                long totalBytes = connection.getContentLengthLong();
                long downloadedBytes = 0L;
                long startTime = System.currentTimeMillis();
                byte[] buffer = new byte[8192];
                while ((bytesRead = in.read(buffer)) != -1) {
                    long elapsedTime;
                    if (progressScreen.isCancelled()) {
                        LOGGER.info("Download cancelled by user.");
                        try {
                            Files.deleteIfExists(temp);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                    out.write(buffer, 0, bytesRead);
                    downloadedBytes += (long)bytesRead;
                    int progress = 0;
                    if (totalBytes > 0L) {
                        progress = (int)(downloadedBytes * 100L / totalBytes);
                    }
                    double speedInKB = (elapsedTime = System.currentTimeMillis() - startTime) > 0L ? (double)downloadedBytes / 1024.0 / ((double)elapsedTime / 1000.0) : 0.0;
                    String speed = speedInKB >= 1024.0 ? String.format("%.2f MB/s", speedInKB / 1024.0) : String.format("%.2f KB/s", speedInKB);
                    progressScreen.updateProgress(progress, speed);
                }
                LOGGER.info("Download finished: wrote {} bytes to temporary file {} (content-length={})", new Object[]{downloadedBytes, temp, totalBytes});
                if (downloadedBytes != 0L) break block26;
                try {
                    Files.deleteIfExists(temp);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new IOException("Downloaded file is empty (0 bytes)");
            }
        }
        try {
            Files.move(temp, destination, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            LOGGER.info("Moved downloaded file {} -> {}", (Object)temp, (Object)destination);
        }
        catch (AtomicMoveNotSupportedException amnse) {
            LOGGER.warn("Atomic move not supported, falling back to non-atomic move for {} -> {}", (Object)temp, (Object)destination);
            Files.move(temp, destination, StandardCopyOption.REPLACE_EXISTING);
            LOGGER.info("Moved downloaded file {} -> {} (non-atomic)", (Object)temp, (Object)destination);
        }
        catch (IOException ioe) {
            LOGGER.error("Failed to move downloaded temp file {} to final destination {}", new Object[]{temp, destination, ioe});
            try {
                Files.deleteIfExists(temp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ioe;
        }
    }

    private static void validateDownloadedFile() throws IOException {
        if (!Files.exists(MOD_DOWNLOAD_PATH, new LinkOption[0]) || Files.size(MOD_DOWNLOAD_PATH) == 0L) {
            throw new IOException("Downloaded file is invalid or empty.");
        }
    }

    private static void prepareDestinationDirectory() throws IOException {
        if (!Files.exists(UNZIP_DESTINATION, new LinkOption[0])) {
            Files.createDirectories(UNZIP_DESTINATION, new FileAttribute[0]);
        }
    }

    private static void extractZipFile() throws IOException {
        extractedModFiles.clear();
        try (InputStream fileInputStream = Files.newInputStream(MOD_DOWNLOAD_PATH, new OpenOption[0]);
             ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                Path entryPath = UNZIP_DESTINATION.resolve(entry.getName()).normalize();
                if (entry.isDirectory()) {
                    Files.createDirectories(entryPath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                    try (OutputStream out = Files.newOutputStream(entryPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = zipInputStream.read(buffer)) > 0) {
                            out.write(buffer, 0, len);
                        }
                    }
                    catch (AccessDeniedException ade) {
                        LOGGER.warn("Access denied when writing {}. Scheduling for deletion on JVM exit.", (Object)entryPath);
                        ClientEventHandlers.sendPlayerMessage("File locked: " + String.valueOf(entryPath.getFileName()) + ". Will be deleted on exit.");
                        try {
                            ClientEventHandlers.forceDeleteOnExit(entryPath.toFile());
                        }
                        catch (IOException ioe) {
                            LOGGER.error("Failed to schedule {} for deletion on exit: {}", (Object)entryPath, (Object)ioe.getMessage());
                        }
                    }
                    if (entryPath.getFileName().toString().endsWith(".jar")) {
                        extractedModFiles.add(entryPath.getFileName().toString());
                    }
                }
                zipInputStream.closeEntry();
            }
        }
    }

    private static void updateChecksumsAndDeleteOutdated() throws Exception {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(UNZIP_DESTINATION, "*.jar");){
            for (Path modFile : stream) {
                String fileName = modFile.getFileName().toString();
                if (extractedModFiles.contains(fileName)) continue;
                try {
                    if (!Files.deleteIfExists(modFile)) continue;
                    LOGGER.info("Deleted outdated mod: {}", (Object)fileName);
                }
                catch (FileSystemException fse) {
                    LOGGER.warn("Could not delete {} because it is locked ({}). Scheduling for deletion on exit.", (Object)fileName, (Object)fse.getMessage());
                    try {
                        ClientEventHandlers.forceDeleteOnExit(modFile.toFile());
                    }
                    catch (IOException ioe) {
                        LOGGER.error("Failed to schedule {} for deletion on exit", (Object)fileName, (Object)ioe);
                    }
                }
                catch (IOException ioe) {
                    LOGGER.error("Unexpected error deleting outdated mod {}", (Object)fileName, (Object)ioe);
                }
            }
        }
        Checksum.saveChecksums(UNZIP_DESTINATION, CHECKSUM_FILE);
    }

    public static void forceDeleteOnExit(File file) throws IOException {
        File[] children;
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                ClientEventHandlers.forceDeleteOnExit(child);
            }
        }
        file.deleteOnExit();
    }

    private static void sendPlayerMessage(String message) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && client.field_1724.method_5682() != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)message), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$downloadAndProcessMod$3(String httpsUrl, String httpUrl, DownloadProgressScreen progressScreen, String serverUpdateIP, class_310 minecraft, class_442 titleScreen) {
        String attemptedUrl = httpsUrl != null ? httpsUrl : httpUrl;
        boolean triedHttps = false;
        boolean triedHttp = false;
        try {
            HttpURLConnection connection = null;
            IOException lastException = null;
            if (httpsUrl != null) {
                attemptedUrl = httpsUrl;
                triedHttps = true;
                try {
                    LOGGER.info("Starting mod download from (HTTPS): {}", (Object)httpsUrl);
                    connection = ClientEventHandlers.initializeConnection(httpsUrl);
                }
                catch (IOException e) {
                    LOGGER.warn("HTTPS download failed, will try HTTP: {}", (Object)e.getMessage());
                    lastException = e;
                }
            }
            if (connection == null && httpUrl != null) {
                attemptedUrl = httpUrl;
                triedHttp = true;
                try {
                    LOGGER.info("Starting mod download from (HTTP): {}", (Object)httpUrl);
                    connection = ClientEventHandlers.initializeConnection(httpUrl);
                }
                catch (IOException e) {
                    lastException = e;
                }
            }
            if (connection == null) {
                throw new IOException("Failed to connect to mod download URL via HTTPS and HTTP", lastException);
            }
            ClientEventHandlers.downloadFileWithProgress(connection, MOD_DOWNLOAD_PATH, progressScreen);
            ClientEventHandlers.validateDownloadedFile();
            ClientEventHandlers.prepareDestinationDirectory();
            ClientEventHandlers.extractZipFile();
            ClientEventHandlers.updateChecksumsAndDeleteOutdated();
            ClientEventHandlers.sendPlayerMessage("Mods downloaded, verified, and extracted successfully for " + serverUpdateIP + "!");
        }
        catch (Exception e) {
            LOGGER.error("Failed to download or extract mods from " + attemptedUrl, (Throwable)e);
            ClientEventHandlers.sendPlayerMessage("Failed to download or extract mods for " + serverUpdateIP + ". Check logs for more details.");
        }
        finally {
            minecraft.execute(() -> minecraft.method_1507((class_437)titleScreen));
        }
    }
}

