/*
 * Decompiled with CFR 0.152.
 */
package com.mmmmm.server;

import com.mmmmm.Config;
import com.mmmmm.MMMMM;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.concurrent.Executors;

public class FileHostingServer {
    private static HttpServer fileHostingServer;
    public static final int FILE_SERVER_PORT;
    public static final Path FILE_DIRECTORY;

    public static void start() throws IOException {
        if (!Files.exists(FILE_DIRECTORY, new LinkOption[0])) {
            Files.createDirectories(FILE_DIRECTORY, new FileAttribute[0]);
        }
        fileHostingServer = HttpServer.create(new InetSocketAddress(FILE_SERVER_PORT), 0);
        fileHostingServer.createContext("/", exchange -> {
            block44: {
                boolean responseStarted = false;
                boolean clientAborted = false;
                long bytesSent = 0L;
                try {
                    String requestPath = exchange.getRequestURI().getPath();
                    InetSocketAddress remote = exchange.getRemoteAddress();
                    MMMMM.LOGGER.info("Received request: {} from {}", (Object)requestPath, (Object)remote);
                    Path filePath = FILE_DIRECTORY.resolve(requestPath.substring(1)).normalize();
                    if (!filePath.startsWith(FILE_DIRECTORY)) {
                        MMMMM.LOGGER.warn("Unauthorized access attempt: {} from {}", (Object)filePath, (Object)remote);
                        exchange.sendResponseHeaders(403, -1L);
                        return;
                    }
                    if (!Files.exists(filePath, new LinkOption[0]) || Files.isDirectory(filePath, new LinkOption[0])) {
                        MMMMM.LOGGER.warn("File not found: {} (from {})", (Object)filePath, (Object)remote);
                        exchange.sendResponseHeaders(404, -1L);
                        return;
                    }
                    long fileSize = Files.size(filePath);
                    if (fileSize == 0L) {
                        MMMMM.LOGGER.warn("Requested file exists but is empty: {} (from {})", (Object)filePath, (Object)remote);
                        exchange.sendResponseHeaders(404, -1L);
                        return;
                    }
                    String contentType = requestPath.endsWith(".zip") ? "application/zip" : "application/octet-stream";
                    exchange.getResponseHeaders().add("Content-Type", contentType);
                    MessageDigest md = MessageDigest.getInstance("SHA-256");
                    exchange.sendResponseHeaders(200, fileSize);
                    responseStarted = true;
                    try (InputStream in = Files.newInputStream(filePath, new OpenOption[0]);
                         DigestInputStream dis = new DigestInputStream(in, md);
                         OutputStream out = exchange.getResponseBody();){
                        int read;
                        byte[] buffer = new byte[8192];
                        while ((read = dis.read(buffer)) != -1) {
                            try {
                                out.write(buffer, 0, read);
                                bytesSent += (long)read;
                            }
                            catch (IOException writeEx) {
                                clientAborted = true;
                                String msg = writeEx.getMessage();
                                if (msg != null && msg.toLowerCase().contains("stream closed")) {
                                    MMMMM.LOGGER.info("Client aborted download of {} from {} after {} bytes (stream closed)", new Object[]{filePath, remote, bytesSent});
                                } else {
                                    MMMMM.LOGGER.info("Client aborted download of {} from {} after {} bytes ({}).", new Object[]{filePath, remote, bytesSent, writeEx.toString()});
                                }
                                break;
                            }
                        }
                    }
                    String sha256 = HexFormat.of().formatHex(md.digest());
                    if (!clientAborted) {
                        MMMMM.LOGGER.info("Successfully served file: {} (fileSize={} bytes, bytesSent={}, sha256={})", new Object[]{filePath, fileSize, bytesSent, sha256});
                        if (bytesSent < fileSize) {
                            MMMMM.LOGGER.warn("Sent fewer bytes ({}) than the file size ({}) for {} \u2014 file may have changed during read.", new Object[]{bytesSent, fileSize, filePath});
                        }
                    }
                }
                catch (IOException e) {
                    if (clientAborted) break block44;
                    MMMMM.LOGGER.error("I/O error while processing request", (Throwable)e);
                    try {
                        if (!responseStarted) {
                            exchange.sendResponseHeaders(500, -1L);
                        }
                    }
                    catch (IOException ioException) {
                        MMMMM.LOGGER.error("Failed to send error response", (Throwable)ioException);
                    }
                }
                catch (Exception e) {
                    MMMMM.LOGGER.error("Unexpected error processing request", (Throwable)e);
                    try {
                        if (!responseStarted) {
                            exchange.sendResponseHeaders(500, -1L);
                        }
                    }
                    catch (IOException ioException) {
                        MMMMM.LOGGER.error("Failed to send error response", (Throwable)ioException);
                    }
                }
                finally {
                    exchange.close();
                }
            }
        });
        fileHostingServer.setExecutor(Executors.newCachedThreadPool());
        new Thread(() -> {
            fileHostingServer.start();
            MMMMM.LOGGER.info("File hosting server started on port " + FILE_SERVER_PORT);
        }).start();
    }

    public static void stop() {
        if (fileHostingServer != null) {
            fileHostingServer.stop(0);
            MMMMM.LOGGER.info("File hosting server stopped.");
        }
    }

    static {
        FILE_SERVER_PORT = Config.fileServerPort;
        FILE_DIRECTORY = Path.of("MMMMM/shared-files", new String[0]);
    }
}

