/*
 * Decompiled with CFR 0.152.
 */
package com.mmmmm.client;

import com.mmmmm.Checksum;
import com.mmmmm.client.DownloadProgressScreen;
import com.mmmmm.client.ServerMetadata;
import com.mmmmm.mixin.MultiplayerScreenAccessor;
import com.mmmmm.mixin.ScreenInvoker;
import com.mmmmm.mixin.ScreenMixin;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_6379;
import net.minecraft.class_641;
import net.minecraft.class_642;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ClientEventHandlers
implements ClientModInitializer {
    private static final int CONNECTION_TIMEOUT_MS = 5000;
    private static final Path MOD_DOWNLOAD_PATH = Path.of("MMMMM/shared-files/mods.zip", new String[0]);
    private static final Path UNZIP_DESTINATION = Path.of("mods", new String[0]);
    private static final Path CHECKSUM_FILE = Path.of("MMMMM/mods_checksums.json", new String[0]);
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientEventHandlers.class);
    private static final List<class_4185> serverButtons = new ArrayList<class_4185>();
    private static class_437 lastScreen = null;

    public void onInitializeClient() {
        new Thread(() -> {
            while (true) {
                class_500 screen;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                class_310 client = class_310.method_1551();
                class_437 current = client.field_1755;
                if (current instanceof class_500 && lastScreen != (screen = (class_500)current)) {
                    lastScreen = screen;
                    client.execute(() -> ClientEventHandlers.addUpdateButtons(screen));
                    continue;
                }
                if (current instanceof class_500) continue;
                lastScreen = null;
            }
        }, "mmmmm-multiplayer-poll").start();
    }

    public static void addUpdateButtons(class_500 screen) {
        int yOffset;
        serverButtons.clear();
        class_641 serverList = ((MultiplayerScreenAccessor)screen).getServerList();
        LOGGER.info("Injecting update buttons for {} servers", (Object)serverList.method_2984());
        int buttonX = screen.field_22789 - 55;
        int buttonY = 50;
        int buttonSpacing = 24;
        int maxHeight = screen.field_22790 - 50;
        int verticalOffset = -12;
        for (int i = 0; i < serverList.method_2984() && (yOffset = buttonY + i * buttonSpacing + verticalOffset) + 20 <= maxHeight; ++i) {
            class_642 server = serverList.method_2982(i);
            class_4185 serverButton = ClientEventHandlers.createServerButton(buttonX, yOffset, server);
            LOGGER.info("Before adding drawable child for server: {}", (Object)server.field_3752);
            ((ScreenInvoker)screen).invokeAddDrawableChild(serverButton);
            ScreenMixin screenMixin = (ScreenMixin)screen;
            screenMixin.invokeChildren().add(0, (class_364)serverButton);
            screenMixin.invokeDrawables().add(0, (class_4068)serverButton);
            screenMixin.invokeSelectables().add(0, (class_6379)serverButton);
            LOGGER.info("After adding drawable child for server: {}", (Object)server.field_3752);
            serverButtons.add(serverButton);
            LOGGER.info("Added update button for server: {}", (Object)server.field_3752);
        }
    }

    private static class_4185 createServerButton(int x, int y, class_642 server) {
        class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Update"), btn -> {
            LOGGER.info("Starting update button for {}", (Object)server.field_3752);
            String serverUpdateIP = ServerMetadata.getMetadata(server.field_3761);
            LOGGER.info("Update button clicked for server: {}", (Object)serverUpdateIP);
            ClientEventHandlers.downloadAndProcessMod(serverUpdateIP);
        }).method_46434(x, y, 50, 20).method_46431();
        button.field_22763 = true;
        return button;
    }

    private static void downloadAndProcessMod(String serverUpdateIP) {
        class_310 minecraft = class_310.method_1551();
        class_442 titleScreen = new class_442();
        Object modsUrl = serverUpdateIP;
        if (modsUrl == null || ((String)modsUrl).isBlank()) {
            LOGGER.info("No mod URL found for " + serverUpdateIP);
            return;
        }
        if (!((String)modsUrl).startsWith("http://") && !((String)modsUrl).startsWith("https://")) {
            modsUrl = "http://" + (String)modsUrl;
        }
        if (!((String)modsUrl).endsWith("/mods.zip")) {
            modsUrl = (String)modsUrl + "/mods.zip";
        }
        String finalModsUrl = modsUrl;
        DownloadProgressScreen progressScreen = new DownloadProgressScreen((String)modsUrl);
        minecraft.method_1507((class_437)progressScreen);
        Executors.newSingleThreadExecutor().execute(() -> {
            try {
                LOGGER.info("Starting mod download from: {}", (Object)finalModsUrl);
                HttpURLConnection connection = ClientEventHandlers.initializeConnection(finalModsUrl);
                ClientEventHandlers.downloadFileWithProgress(connection, MOD_DOWNLOAD_PATH, progressScreen);
                ClientEventHandlers.validateDownloadedFile();
                ClientEventHandlers.prepareDestinationDirectory();
                ClientEventHandlers.compareChecksumsIfExists();
                ClientEventHandlers.extractZipFile();
                ClientEventHandlers.saveUpdatedChecksums();
                ClientEventHandlers.sendPlayerMessage("Mods downloaded, verified, and extracted successfully for " + serverUpdateIP + "!");
            }
            catch (Exception e) {
                LOGGER.error("Failed to download or extract mods", (Throwable)e);
                ClientEventHandlers.sendPlayerMessage("Failed to download or extract mods for " + serverUpdateIP + ". Check logs for more details.");
            }
            finally {
                minecraft.execute(() -> minecraft.method_1507((class_437)titleScreen));
            }
        });
    }

    private static HttpURLConnection initializeConnection(String url) throws IOException {
        URL downloadUrl = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)downloadUrl.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestMethod("GET");
        int responseCode = connection.getResponseCode();
        LOGGER.info("Connecting to {} - Response Code: {}", (Object)url, (Object)responseCode);
        if (responseCode != 200) {
            throw new IOException("Failed to fetch mods - Server returned response code: " + responseCode);
        }
        return connection;
    }

    private static void downloadFileWithProgress(HttpURLConnection connection, Path destination, DownloadProgressScreen progressScreen) throws IOException {
        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        if (!Files.exists(destination, new LinkOption[0])) {
            Files.createFile(destination, new FileAttribute[0]);
        }
        try (InputStream in = connection.getInputStream();
             OutputStream out = Files.newOutputStream(destination, new OpenOption[0]);){
            int bytesRead;
            long totalBytes = connection.getContentLengthLong();
            long downloadedBytes = 0L;
            long startTime = System.currentTimeMillis();
            byte[] buffer = new byte[8192];
            while ((bytesRead = in.read(buffer)) != -1) {
                if (progressScreen.isCancelled()) {
                    LOGGER.info("Download cancelled by user.");
                    return;
                }
                out.write(buffer, 0, bytesRead);
                int progress = (int)((downloadedBytes += (long)bytesRead) * 100L / totalBytes);
                long elapsedTime = System.currentTimeMillis() - startTime;
                double speedInKB = elapsedTime > 0L ? (double)downloadedBytes / 1024.0 / ((double)elapsedTime / 1000.0) : 0.0;
                String speed = speedInKB >= 1024.0 ? String.format("%.2f MB/s", speedInKB / 1024.0) : String.format("%.2f KB/s", speedInKB);
                progressScreen.updateProgress(progress, speed);
            }
        }
    }

    private static void validateDownloadedFile() throws IOException {
        if (!Files.exists(MOD_DOWNLOAD_PATH, new LinkOption[0]) || Files.size(MOD_DOWNLOAD_PATH) == 0L) {
            throw new IOException("Downloaded file is invalid or empty.");
        }
    }

    private static void prepareDestinationDirectory() throws IOException {
        if (!Files.exists(UNZIP_DESTINATION, new LinkOption[0])) {
            Files.createDirectories(UNZIP_DESTINATION, new FileAttribute[0]);
        }
    }

    private static void compareChecksumsIfExists() throws Exception {
        if (Files.exists(CHECKSUM_FILE, new LinkOption[0])) {
            LOGGER.info("Comparing checksums...");
            Checksum.compareChecksums(UNZIP_DESTINATION, CHECKSUM_FILE);
        }
    }

    private static void extractZipFile() throws IOException {
        try (InputStream fileInputStream = Files.newInputStream(MOD_DOWNLOAD_PATH, new OpenOption[0]);
             ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                Path entryPath = UNZIP_DESTINATION.resolve(entry.getName()).normalize();
                if (entry.isDirectory()) {
                    Files.createDirectories(entryPath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                    Files.copy(zipInputStream, entryPath, StandardCopyOption.REPLACE_EXISTING);
                }
                zipInputStream.closeEntry();
            }
        }
    }

    private static void saveUpdatedChecksums() throws Exception {
        LOGGER.info("Saving updated checksums...");
        Checksum.saveChecksums(UNZIP_DESTINATION, CHECKSUM_FILE);
    }

    private static void sendPlayerMessage(String message) {
        if (class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)message));
        }
    }
}

