/*
 * Decompiled with CFR 0.152.
 */
package com.mmmmm;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterCommands {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisterCommands.class);

    public static void onRegisterCommands(RegisterCommandsEvent event) {
        LOGGER.info("Registering server commands...");
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"mmmmm").then(((LiteralArgumentBuilder)Commands.literal((String)"save-mods").requires(source -> source.hasPermission(2))).executes(context -> {
            RegisterCommands.saveModsToZip();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Mods have been saved to mods.zip in the shared-files directory."), true);
            return 1;
        })));
    }

    public static void saveModsToZip() {
        Executors.newSingleThreadExecutor().execute(() -> {
            Path modsFolder = Path.of("mods", new String[0]);
            Path modsZip = Path.of("MMMMM/shared-files/mods.zip", new String[0]);
            try (ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(modsZip, new OpenOption[0]));){
                Files.walk(modsFolder, new FileVisitOption[0]).forEach(path -> {
                    try {
                        if (Files.isRegularFile(path, new LinkOption[0])) {
                            Path relativePath = modsFolder.relativize((Path)path);
                            ZipEntry zipEntry = new ZipEntry(relativePath.toString());
                            zipOut.putNextEntry(zipEntry);
                            Files.copy(path, zipOut);
                            zipOut.closeEntry();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to add file to mods.zip: " + String.valueOf(path), (Throwable)e);
                    }
                });
                LOGGER.info("Successfully created mods.zip in shared-files.");
            }
            catch (IOException e) {
                LOGGER.error("Failed to create mods.zip", (Throwable)e);
            }
            finally {
                Executors.newSingleThreadExecutor().shutdown();
            }
        });
    }
}

