/*
 * Decompiled with CFR 0.152.
 */
package com.mmmmm;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mmmmm.Config;
import com.moandjiezana.toml.Toml;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterCommands {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisterCommands.class);
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final HttpClient httpClient = HttpClient.newHttpClient();
    private static final Map<String, Boolean> modrinthCache = new HashMap<String, Boolean>();
    private static FileTime lastBuildTime = FileTime.fromMillis(0L);

    public static void onRegisterCommands(RegisterCommandsEvent event) {
        LOGGER.info("Registering server commands...");
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"mmmmm").then(((LiteralArgumentBuilder)Commands.literal((String)"save-mods").requires(source -> source.hasPermission(2))).executes(context -> {
            RegisterCommands.saveModsToZip();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Zipping mods... check console for progress."), true);
            return 1;
        })));
    }

    public static void saveModsToZip() {
        executor.execute(() -> {
            Path modsFolder = Path.of("mods", new String[0]);
            Path modsZip = Path.of("MMMMM/shared-files/mods.zip", new String[0]);
            try {
                List modFiles = Files.walk(modsFolder, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith(".jar")).collect(Collectors.toList());
                if (modFiles.isEmpty()) {
                    LOGGER.warn("No .jar files found in mods folder, skipping zip.");
                    return;
                }
                FileTime latestChange = modFiles.stream().map(path -> {
                    try {
                        return Files.getLastModifiedTime(path, new LinkOption[0]);
                    }
                    catch (IOException e) {
                        return FileTime.fromMillis(0L);
                    }
                }).max(FileTime::compareTo).orElse(FileTime.fromMillis(0L));
                if (latestChange.compareTo(lastBuildTime) <= 0 && Files.exists(modsZip, new LinkOption[0])) {
                    LOGGER.info("Mods have not changed since last build. Skipping zip creation.");
                    return;
                }
                LOGGER.info("Starting mods.zip creation. Found {} mods.", (Object)modFiles.size());
                try (ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(modsZip, new OpenOption[0]));){
                    int total = modFiles.size();
                    int index = 0;
                    for (Path path2 : modFiles) {
                        ++index;
                        try {
                            String modName = RegisterCommands.getModNameFromJar(path2);
                            if (modName != null) {
                                boolean exclude;
                                boolean bl = exclude = Config.filterServerSideMods && RegisterCommands.isServerOnlyMod(modName);
                                if (!exclude) {
                                    Path relativePath = modsFolder.relativize(path2);
                                    ZipEntry zipEntry = new ZipEntry(relativePath.toString());
                                    zipOut.putNextEntry(zipEntry);
                                    Files.copy(path2, zipOut);
                                    zipOut.closeEntry();
                                    LOGGER.info("[{}/{}] Included mod: {} ({})", new Object[]{index, total, modName, path2.getFileName()});
                                    continue;
                                }
                                LOGGER.info("[{}/{}] Excluded mod: {} ({})", new Object[]{index, total, modName, path2.getFileName()});
                                continue;
                            }
                            LOGGER.warn("[{}/{}] Could not identify mod: {}", new Object[]{index, total, path2.getFileName()});
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to process mod: " + String.valueOf(path2), (Throwable)e);
                        }
                    }
                }
                lastBuildTime = latestChange;
                LOGGER.info("Finished creating mods.zip in shared-files. {} mods processed.", (Object)modFiles.size());
            }
            catch (IOException e) {
                LOGGER.error("Failed to create mods.zip", (Throwable)e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getModNameFromJar(Path jarPath) {
        try (ZipFile zipFile = new ZipFile(jarPath.toFile());){
            ZipEntry entry = zipFile.getEntry("META-INF/neoforge.mods.toml");
            if (entry == null) return jarPath.getFileName().toString();
            try (InputStream is = zipFile.getInputStream(entry);){
                Toml toml = new Toml().read(is);
                String rootDisplayName = toml.getString("display_name");
                if (rootDisplayName != null) {
                    String string = rootDisplayName;
                    return string;
                }
                List modsList = toml.getTables("mods");
                if (modsList == null) return jarPath.getFileName().toString();
                if (modsList.isEmpty()) return jarPath.getFileName().toString();
                Toml firstMod = (Toml)modsList.get(0);
                String modDisplayName = firstMod.getString("displayName");
                if (modDisplayName == null) return jarPath.getFileName().toString();
                String string = modDisplayName;
                return string;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to read toml from: " + String.valueOf(jarPath) + ", using file name as fallback.", (Throwable)e);
            return jarPath.getFileName().toString();
        }
    }

    private static boolean isServerOnlyMod(String modName) {
        if (modrinthCache.containsKey(modName)) {
            return modrinthCache.get(modName);
        }
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.modrinth.com/v2/search?query=" + URLEncoder.encode(modName, "UTF-8"))).header("User-Agent", "Place-Boy/https://github.com/Place-Boy/MMMMM/1.0.1-beta").GET().build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            JsonObject json = JsonParser.parseString((String)response.body()).getAsJsonObject();
            JsonArray hits = json.getAsJsonArray("hits");
            if (hits != null && hits.size() > 0) {
                JsonObject mod = hits.get(0).getAsJsonObject();
                String clientSide = mod.has("client_side") ? mod.get("client_side").getAsString() : "required";
                String serverSide = mod.has("server_side") ? mod.get("server_side").getAsString() : "required";
                boolean result = "unsupported".equalsIgnoreCase(clientSide) && "required".equalsIgnoreCase(serverSide);
                modrinthCache.put(modName, result);
                return result;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to query Modrinth for: " + modName, (Throwable)e);
        }
        modrinthCache.put(modName, false);
        return false;
    }
}

