/*
 * Decompiled with CFR 0.152.
 */
package com.mmmmm.client;

import com.mmmmm.Checksum;
import com.mmmmm.client.DownloadProgressScreen;
import com.mmmmm.client.ServerMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber(modid="mmmmm", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClientEventHandlers {
    private static final int CONNECTION_TIMEOUT_MS = 5000;
    private static final Path MOD_DOWNLOAD_PATH = Path.of("MMMMM/shared-files/mods.zip", new String[0]);
    private static final Path UNZIP_DESTINATION = Path.of("mods", new String[0]);
    private static final Path CHECKSUM_FILE = Path.of("MMMMM/mods_checksums.json", new String[0]);
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientEventHandlers.class);
    private static final List<Button> serverButtons = new ArrayList<Button>();

    @SubscribeEvent
    public static void onMultiplayerScreenInit(ScreenEvent.Init.Post event) {
        int yOffset;
        Screen screen = event.getScreen();
        if (!(screen instanceof JoinMultiplayerScreen)) {
            return;
        }
        JoinMultiplayerScreen screen2 = (JoinMultiplayerScreen)screen;
        LOGGER.info("Multiplayer screen initialized. Adding server buttons.");
        ServerList serverList = new ServerList(Minecraft.getInstance());
        serverList.load();
        int buttonX = screen2.width - 55;
        int buttonY = 50;
        int buttonSpacing = 24;
        int maxHeight = screen2.height - 50;
        for (int i = 0; i < serverList.size() && (yOffset = buttonY + i * buttonSpacing) + 20 <= maxHeight; ++i) {
            ServerData server = serverList.get(i);
            Button serverButton = ClientEventHandlers.createServerButton(buttonX, yOffset, server);
            event.addListener((GuiEventListener)serverButton);
            serverButtons.add(serverButton);
        }
    }

    private static Button createServerButton(int x, int y, ServerData server) {
        return Button.builder((Component)Component.literal((String)"Update"), btn -> {
            String serverUpdateIP = ServerMetadata.getMetadata(server.ip);
            LOGGER.info("Update button clicked for server: {}", (Object)serverUpdateIP);
            ClientEventHandlers.downloadAndProcessMod(serverUpdateIP);
        }).bounds(x, y, 50, 20).build();
    }

    private static void downloadAndProcessMod(String serverUpdateIP) {
        Minecraft minecraft = Minecraft.getInstance();
        TitleScreen titleScreen = new TitleScreen();
        Object modsUrl = serverUpdateIP;
        if (modsUrl == null || ((String)modsUrl).isBlank()) {
            LOGGER.info("No mod URL found for " + serverUpdateIP);
            return;
        }
        if (!((String)modsUrl).startsWith("http://") && !((String)modsUrl).startsWith("https://")) {
            modsUrl = "http://" + (String)modsUrl;
        }
        if (!((String)modsUrl).endsWith("/mods.zip")) {
            modsUrl = (String)modsUrl + "/mods.zip";
        }
        String finalModsUrl = modsUrl;
        DownloadProgressScreen progressScreen = new DownloadProgressScreen((String)modsUrl);
        minecraft.setScreen((Screen)progressScreen);
        Executors.newSingleThreadExecutor().execute(() -> {
            try {
                LOGGER.info("Starting mod download from: {}", (Object)finalModsUrl);
                HttpURLConnection connection = ClientEventHandlers.initializeConnection(finalModsUrl);
                ClientEventHandlers.downloadFileWithProgress(connection, MOD_DOWNLOAD_PATH, progressScreen);
                minecraft.execute(() -> progressScreen.startExtraction("Extracting mods..."));
                ClientEventHandlers.validateDownloadedFile();
                ClientEventHandlers.prepareDestinationDirectory();
                ClientEventHandlers.compareChecksumsIfExists();
                ClientEventHandlers.extractZipFile();
                ClientEventHandlers.saveUpdatedChecksums();
                ClientEventHandlers.sendPlayerMessage("Mods downloaded, verified, and extracted successfully for " + serverUpdateIP + "!");
            }
            catch (Exception e) {
                LOGGER.error("Failed to download or extract mods", (Throwable)e);
                ClientEventHandlers.sendPlayerMessage("Failed to download or extract mods for " + serverUpdateIP + ". Check logs for more details.");
            }
            finally {
                minecraft.execute(() -> minecraft.setScreen((Screen)titleScreen));
                Executors.newSingleThreadExecutor().shutdown();
            }
        });
    }

    private static HttpURLConnection initializeConnection(String url) throws IOException {
        URL downloadUrl = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)downloadUrl.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestMethod("GET");
        int responseCode = connection.getResponseCode();
        LOGGER.info("Connecting to {} - Response Code: {}", (Object)url, (Object)responseCode);
        if (responseCode != 200) {
            throw new IOException("Failed to fetch mods - Server returned response code: " + responseCode);
        }
        return connection;
    }

    private static void downloadFileWithProgress(HttpURLConnection connection, Path destination, DownloadProgressScreen progressScreen) throws IOException {
        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        if (!Files.exists(destination, new LinkOption[0])) {
            Files.createFile(destination, new FileAttribute[0]);
        }
        try (InputStream in = connection.getInputStream();
             OutputStream out = Files.newOutputStream(destination, new OpenOption[0]);){
            int bytesRead;
            long totalBytes = connection.getContentLengthLong();
            long downloadedBytes = 0L;
            long startTime = System.currentTimeMillis();
            byte[] buffer = new byte[8192];
            while ((bytesRead = in.read(buffer)) != -1) {
                String eta;
                double secondsRemaining;
                if (progressScreen.isCancelled()) {
                    LOGGER.info("Download cancelled by user.");
                    return;
                }
                out.write(buffer, 0, bytesRead);
                int progress = (int)((downloadedBytes += (long)bytesRead) * 100L / totalBytes);
                long elapsedTime = System.currentTimeMillis() - startTime;
                double speedInKB = elapsedTime > 0L ? (double)downloadedBytes / 1024.0 / ((double)elapsedTime / 1000.0) : 0.0;
                String speed = speedInKB >= 1024.0 ? String.format("%.2f MB/s", speedInKB / 1024.0) : String.format("%.2f KB/s", speedInKB);
                long bytesRemaining = totalBytes - downloadedBytes;
                double d = secondsRemaining = speedInKB > 0.0 ? (double)bytesRemaining / 1024.0 / speedInKB : 0.0;
                if (secondsRemaining > 0.0) {
                    int minutes = (int)(secondsRemaining / 60.0);
                    int seconds = (int)(secondsRemaining % 60.0);
                    eta = String.format("%dm %ds", minutes, seconds);
                } else {
                    eta = "Calculating...";
                }
                progressScreen.updateProgress(progress, speed, eta);
            }
        }
    }

    private static void validateDownloadedFile() throws IOException {
        if (!Files.exists(MOD_DOWNLOAD_PATH, new LinkOption[0]) || Files.size(MOD_DOWNLOAD_PATH) == 0L) {
            throw new IOException("Downloaded file is invalid or empty.");
        }
    }

    private static void prepareDestinationDirectory() throws IOException {
        if (!Files.exists(UNZIP_DESTINATION, new LinkOption[0])) {
            Files.createDirectories(UNZIP_DESTINATION, new FileAttribute[0]);
        }
    }

    private static void compareChecksumsIfExists() throws Exception {
        if (Files.exists(CHECKSUM_FILE, new LinkOption[0])) {
            LOGGER.info("Comparing checksums...");
            Checksum.compareChecksums(UNZIP_DESTINATION, CHECKSUM_FILE);
        }
    }

    private static void extractZipFile() throws IOException {
        try (InputStream fileInputStream = Files.newInputStream(MOD_DOWNLOAD_PATH, new OpenOption[0]);
             ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                Path entryPath = UNZIP_DESTINATION.resolve(entry.getName()).normalize();
                if (entry.isDirectory()) {
                    Files.createDirectories(entryPath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                    Files.copy(zipInputStream, entryPath, StandardCopyOption.REPLACE_EXISTING);
                }
                zipInputStream.closeEntry();
            }
        }
    }

    private static void saveUpdatedChecksums() throws Exception {
        LOGGER.info("Saving updated checksums...");
        Checksum.saveChecksums(UNZIP_DESTINATION, CHECKSUM_FILE);
    }

    private static void sendPlayerMessage(String message) {
        if (Minecraft.getInstance().player != null) {
            Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)message));
        }
    }
}

