/*
 * Decompiled with CFR 0.152.
 */
package com.mmmmm.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ServerMetadata {
    private static final File METADATA_FILE = new File("MMMMM/server_metadata.json");
    private static final Gson GSON = new Gson();
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerMetadata.class);
    private static Map<String, String> serverMetadata = new HashMap<String, String>();

    private static void loadMetadata() {
        if (METADATA_FILE.exists()) {
            try (FileReader reader = new FileReader(METADATA_FILE);){
                Type type = new TypeToken<Map<String, String>>(){}.getType();
                Map loadedData = (Map)GSON.fromJson((Reader)reader, type);
                if (loadedData != null) {
                    serverMetadata = loadedData;
                }
                LOGGER.info("Metadata loaded successfully.");
            }
            catch (Exception e) {
                LOGGER.error("Failed to load metadata.", (Throwable)e);
            }
        } else {
            LOGGER.warn("Metadata file does not exist. Starting with an empty metadata map.");
        }
    }

    public static void saveMetadata() {
        try {
            File parentDir = METADATA_FILE.getParentFile();
            if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                LOGGER.error("Failed to create metadata directory: {}", (Object)parentDir.getAbsolutePath());
                return;
            }
            try (FileWriter writer = new FileWriter(METADATA_FILE);){
                GSON.toJson(serverMetadata, (Appendable)writer);
                LOGGER.info("Metadata saved successfully to {}", (Object)METADATA_FILE.getAbsolutePath());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to save metadata.", (Throwable)e);
        }
    }

    public static String getMetadata(String serverIP) {
        return serverMetadata.getOrDefault(serverIP, "");
    }

    public static void setMetadata(String serverIP, String value) {
        if (ServerMetadata.isValidServerIP(serverIP) && ServerMetadata.isValidMetadataValue(value)) {
            serverMetadata.put(serverIP, value);
            ServerMetadata.saveMetadata();
            LOGGER.info("Metadata updated for server: {}", (Object)serverIP);
        } else {
            LOGGER.warn("Invalid server IP or metadata value. Skipping update.");
        }
    }

    private static boolean isValidServerIP(String serverIP) {
        return serverIP != null && !serverIP.isBlank();
    }

    private static boolean isValidMetadataValue(String value) {
        return value != null && !value.isBlank();
    }

    public static Map<String, String> getAllMetadata() {
        return Collections.unmodifiableMap(serverMetadata);
    }

    static {
        ServerMetadata.loadMetadata();
    }
}

