/*
 * Decompiled with CFR 0.152.
 */
package net.enchantoutline;

import it.unimi.dsi.fastutil.Function;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedMap;
import net.enchantoutline.config.EnchantmentOutlineConfig;
import net.enchantoutline.config.ItemOverride;
import net.enchantoutline.events.BufferBuilderModifyReturnValue;
import net.enchantoutline.events.EquipmentRendererQueueEnchantedCallback;
import net.enchantoutline.events.ImmediateRenderCurrentLayer;
import net.enchantoutline.events.ItemModelManagerUpdateModelCallback;
import net.enchantoutline.events.ItemRenderStateRenderLayerCallback;
import net.enchantoutline.events.LayerRenderStateRenderSpecial;
import net.enchantoutline.events.RenderQuads;
import net.enchantoutline.events.TridentEntityRendererQueueEnchantedCallback;
import net.enchantoutline.events.WorldRenderer;
import net.enchantoutline.mixin_accessors.ItemRenderStateAccessor;
import net.enchantoutline.mixin_accessors.ItemRenderState_LayerRenderStateAccessor;
import net.enchantoutline.mixin_accessors.OrderedRenderCommandQueueImplAccessor;
import net.enchantoutline.mixin_accessors.RenderLayerAccessor;
import net.enchantoutline.mixin_accessors.VertexConsumerProvider_ImmediateAccessor;
import net.enchantoutline.model.HijackedModel;
import net.enchantoutline.shader.Shaders;
import net.enchantoutline.util.CustomRenderLayers;
import net.enchantoutline.util.ModelHelper;
import net.enchantoutline.util.QuadHelper;
import net.enchantoutline.util.RenderLayerHelper;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_10444;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4722;
import net.minecraft.class_630;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import net.minecraft.class_955;
import net.minecraft.class_9799;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnchantmentGlintOutline
implements ModInitializer {
    public static final String MOD_ID = "enchantment-glint-outline";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"enchantment-glint-outline");
    public static final CustomRenderLayers GLINT_LAYERS = new CustomRenderLayers();
    public static final CustomRenderLayers COLOR_LAYERS = new CustomRenderLayers();
    public static final CustomRenderLayers ZFIX_LAYERS = new CustomRenderLayers();
    private static EnchantmentOutlineConfig config;
    public static final ThreadLocal<class_10444.class_10446> LAYER_RENDER_STATE_RENDER_MODEL_STORAGE;

    public static EnchantmentOutlineConfig getConfig() {
        return config;
    }

    public static int getColorBatchingQueue() {
        return -9124657;
    }

    public static int getZFixBatchingQueue() {
        return 9124657;
    }

    private static class_1921 getTargetEnchantGlintLayer() {
        return class_1921.method_27949();
    }

    private static class_1921 getTargetEnchantColorLayer() {
        return class_4722.method_24073();
    }

    private static class_1921 getTargetEnchantZFixLayer() {
        return class_1921.method_23589();
    }

    public void onInitialize() {
        EnchantmentGlintOutline.loadConfig();
        EnchantmentGlintOutline.initLayers();
        RenderQuads.Normal.Callback.EVENT.register((receiver, orderedRenderCommandQueue, matrixStack, itemDisplayContext, light, overlay, outlineColors, tintLayers, quads, renderLayer, glintType) -> {
            if (config.isEnabled() && glintType != class_10444.class_10445.field_55341) {
                @Nullable ItemOverride override = this.getOverrideFromLayerRenderState((Function<String, ItemOverride>)((Function)config::getItemOverride), receiver);
                if (override == null || override.shouldRender()) {
                    float scale = config.getScaleFactorFromOutlineSize(config.getOutlineSizeOverrideOrDefault(override, false));
                    List<class_777> thickenedQuads = QuadHelper.thickenQuad(quads, scale);
                    if (config.getRenderSolidOverrideOrDefault(override, false)) {
                        int[] tint = new int[]{config.getOutlineColorAsInt(config.getOutlineColorOverrideOrDefault(override))};
                        orderedRenderCommandQueue.method_73480(matrixStack, itemDisplayContext, 0, 0, outlineColors, tint, thickenedQuads, Shaders.COLOR_CUTOUT_LAYER, class_10444.class_10445.field_55341);
                        orderedRenderCommandQueue.method_73480(matrixStack, itemDisplayContext, 0, 0, outlineColors, tintLayers, thickenedQuads, Shaders.ZFIX_CUTOUT_LAYER, class_10444.class_10445.field_55341);
                    } else {
                        orderedRenderCommandQueue.method_73480(matrixStack, itemDisplayContext, 0, 0, outlineColors, tintLayers, thickenedQuads, Shaders.GLINT_CUTOUT_LAYER, glintType);
                    }
                }
            }
            return class_1269.field_5811;
        });
        RenderQuads.Model.ModelPart.EVENT.register((receiver, part, matrices, renderLayer, light, overlay, sprite, sheeted, hasGlint, tintedColor, crumblingOverlay, i) -> {
            if (config.isEnabled() && hasGlint) {
                class_10444.class_10446 storedLayerRenderState = LAYER_RENDER_STATE_RENDER_MODEL_STORAGE.get();
                ItemOverride override = null;
                if (storedLayerRenderState != null) {
                    override = this.getOverrideFromLayerRenderState((Function<String, ItemOverride>)((Function)config::getItemOverride), storedLayerRenderState);
                }
                boolean isDoubleSided = RenderLayerHelper.isRenderLayerDoubleSided(renderLayer);
                float scale = config.getScaleFactorFromOutlineSize(config.getOutlineSizeOverrideOrDefault(override, false));
                class_630 thickModelPart = ModelHelper.thickenedModelPart(part, scale);
                if (override == null || override.shouldRender()) {
                    if (config.getRenderSolidOverrideOrDefault(override, false)) {
                        int tint = config.getOutlineColorAsInt(config.getOutlineColorOverrideOrDefault(override));
                        class_1921 colorLayer = RenderLayerHelper.renderLayerFromRenderLayerDoubleSided(renderLayer, COLOR_LAYERS, Shaders::createColorRenderLayerNoCull, Shaders::createColorRenderLayerCull, Shaders.COLOR_CUTOUT_LAYER, isDoubleSided);
                        class_1921 zFixLayer = RenderLayerHelper.renderLayerFromRenderLayerDoubleSided(renderLayer, ZFIX_LAYERS, Shaders::createZFixRenderLayerNoCull, Shaders::createZFixRenderLayerCull, Shaders.ZFIX_CUTOUT_LAYER, isDoubleSided);
                        OrderedRenderCommandQueueImplAccessor commandQueueAccessor = (OrderedRenderCommandQueueImplAccessor)receiver;
                        commandQueueAccessor.enchantOutline$setSkipModelPartCallback(true);
                        receiver.method_73531(EnchantmentGlintOutline.getColorBatchingQueue()).method_73494(thickModelPart, matrices, colorLayer, Integer.MAX_VALUE, 0, sprite, sheeted, false, tint, crumblingOverlay, i);
                        receiver.method_73531(EnchantmentGlintOutline.getZFixBatchingQueue()).method_73494(thickModelPart, matrices, zFixLayer, Integer.MAX_VALUE, 0, sprite, sheeted, false, tint, crumblingOverlay, i);
                        commandQueueAccessor.enchantOutline$setSkipModelPartCallback(false);
                    } else {
                        class_1921 glintLayer = RenderLayerHelper.renderLayerFromRenderLayerDoubleSided(renderLayer, GLINT_LAYERS, Shaders::createGlintRenderLayerNoCull, Shaders::createGlintRenderLayerCull, Shaders.GLINT_CUTOUT_LAYER, isDoubleSided);
                        OrderedRenderCommandQueueImplAccessor commandQueueAccessor = (OrderedRenderCommandQueueImplAccessor)receiver;
                        commandQueueAccessor.enchantOutline$setSkipModelPartCallback(true);
                        receiver.method_73531(EnchantmentGlintOutline.getZFixBatchingQueue()).method_73494(thickModelPart, matrices, glintLayer, Integer.MAX_VALUE, 0, sprite, sheeted, true, tintedColor, crumblingOverlay, i);
                        commandQueueAccessor.enchantOutline$setSkipModelPartCallback(false);
                    }
                }
            }
            return class_1269.field_5811;
        });
        EquipmentRendererQueueEnchantedCallback.EVENT.register((queueHolder, renderedStack, queue, texture, model, s, matrixStack, renderLayer, light, overlay, tintColor, sprite, outlineColor, crumblingOverlayCommand) -> {
            if (config.isEnabled()) {
                ItemOverride override = null;
                if (renderedStack != null) {
                    override = this.getOverrideFromNullableItem((Function<String, ItemOverride>)((Function)config::getArmorOverride), renderedStack.method_7909());
                }
                if (override == null && config.shouldRenderArmor() || override != null && override.shouldRender()) {
                    model.method_2819(s);
                    float scale = config.getScaleFactorFromOutlineSize(config.getOutlineSizeOverrideOrDefault(override, true));
                    if (config.getRenderSolidOverrideOrDefault(override, true)) {
                        int tint = config.getOutlineColorAsInt(config.getOutlineColorOverrideOrDefault(override));
                        class_1921 colorLayer = RenderLayerHelper.renderLayerFromIdentifierDoubleSided(texture, COLOR_LAYERS, Shaders::createColorRenderLayerNoCull, Shaders::createColorRenderLayerCull, Shaders.COLOR_CUTOUT_LAYER, true);
                        HijackedModel thickColorModel = ModelHelper.getThickenedModel(model, layer -> Shaders.COLOR_CUTOUT_LAYER, scale);
                        queueHolder.method_73529(EnchantmentGlintOutline.getColorBatchingQueue()).method_73490((class_3879)thickColorModel, s, matrixStack, colorLayer, Integer.MAX_VALUE, 0, tint, sprite, outlineColor, crumblingOverlayCommand);
                    } else {
                        class_1921 glintZLayer = RenderLayerHelper.renderLayerFromIdentifierDoubleSided(texture, GLINT_LAYERS, Shaders::createGlintRenderLayerNoCull, Shaders::createGlintRenderLayerCull, Shaders.GLINT_CUTOUT_LAYER, true);
                        HijackedModel thickGlintZModel = ModelHelper.getThickenedModel(model, layer -> Shaders.GLINT_CUTOUT_LAYER, scale);
                        queueHolder.method_73529(EnchantmentGlintOutline.getZFixBatchingQueue()).method_73490((class_3879)thickGlintZModel, s, matrixStack, glintZLayer, light, overlay, tintColor, sprite, outlineColor, crumblingOverlayCommand);
                        queueHolder.method_73529(EnchantmentGlintOutline.getZFixBatchingQueue() + 1).method_73490((class_3879)thickGlintZModel, s, matrixStack, Shaders.ARMOR_ENTITY_GLINT_FIX, light, overlay, tintColor, sprite, outlineColor, crumblingOverlayCommand);
                    }
                }
            }
            return class_1269.field_5811;
        });
        TridentEntityRendererQueueEnchantedCallback.EVENT.register((queueHolder, queue, model, s, matrixStack, renderLayer, light, overlay, tintColor, sprite, outlineColor, crumblingOverlayCommand) -> {
            if (config.isEnabled() && renderLayer.equals(class_1921.method_23591())) {
                @Nullable ItemOverride override = this.getOverrideFromNullableItem((Function<String, ItemOverride>)((Function)config::getItemOverride), class_1802.field_8547);
                if (override == null || override.shouldRender()) {
                    float scale = config.getScaleFactorFromOutlineSize(config.getOutlineSizeOverrideOrDefault(override, true));
                    if (config.getRenderSolidOverrideOrDefault(override, false)) {
                        int tint = config.getOutlineColorAsInt(config.getOutlineColorOverrideOrDefault(override));
                        class_1921 colorLayer = RenderLayerHelper.renderLayerFromIdentifierDoubleSided(class_955.field_4796, COLOR_LAYERS, Shaders::createColorRenderLayerNoCull, Shaders::createColorRenderLayerCull, Shaders.COLOR_CUTOUT_LAYER, false);
                        HijackedModel thickColorModel = ModelHelper.getThickenedModel(model, layer -> Shaders.COLOR_CUTOUT_LAYER, scale);
                        queueHolder.method_73529(EnchantmentGlintOutline.getColorBatchingQueue()).method_73490((class_3879)thickColorModel, s, matrixStack, colorLayer, Integer.MAX_VALUE, 0, tint, sprite, outlineColor, crumblingOverlayCommand);
                    } else {
                        class_1921 glintZLayer = RenderLayerHelper.renderLayerFromIdentifierDoubleSided(class_955.field_4796, GLINT_LAYERS, Shaders::createGlintRenderLayerNoCull, Shaders::createGlintRenderLayerCull, Shaders.GLINT_CUTOUT_LAYER, false);
                        HijackedModel thickGlintZModel = ModelHelper.getThickenedModel(model, layer -> Shaders.GLINT_CUTOUT_LAYER, scale);
                        queueHolder.method_73529(EnchantmentGlintOutline.getZFixBatchingQueue()).method_73490((class_3879)thickGlintZModel, s, matrixStack, glintZLayer, light, overlay, tintColor, sprite, outlineColor, crumblingOverlayCommand);
                        queueHolder.method_73529(EnchantmentGlintOutline.getZFixBatchingQueue() + 1).method_73490((class_3879)thickGlintZModel, s, matrixStack, renderLayer, light, overlay, tintColor, sprite, outlineColor, crumblingOverlayCommand);
                    }
                }
            }
            return class_1269.field_5811;
        });
        WorldRenderer.RenderLayer.Callback.EVENT.register((receiver, renderLayer) -> {
            if (renderLayer.equals(EnchantmentGlintOutline.getTargetEnchantColorLayer())) {
                for (class_1921 customLayer : COLOR_LAYERS.renderLayers()) {
                    if (!((RenderLayerAccessor)customLayer).enchantOutline$shouldUseLayerBuffer()) continue;
                    receiver.method_22994(customLayer);
                }
            }
            return class_1269.field_5811;
        });
        WorldRenderer.RenderLayer.Callback.EVENT.register((receiver, renderLayer) -> {
            if (renderLayer.equals(EnchantmentGlintOutline.getTargetEnchantGlintLayer())) {
                for (class_1921 customLayer : GLINT_LAYERS.renderLayers()) {
                    if (!((RenderLayerAccessor)customLayer).enchantOutline$shouldUseLayerBuffer()) continue;
                    receiver.method_22994(customLayer);
                }
            }
            return class_1269.field_5811;
        });
        ImmediateRenderCurrentLayer.Before.EVENT.register((receiver, layer) -> {
            for (class_1921 renderLayer : ((VertexConsumerProvider_ImmediateAccessor)receiver).enchantOutline$getLayerBuffers().keySet()) {
                if (!((RenderLayerAccessor)renderLayer).enchantOutline$shouldDrawBeforeCustom()) continue;
                receiver.method_22994(renderLayer);
            }
            return class_1269.field_5811;
        });
        ImmediateRenderCurrentLayer.After.EVENT.register((receiver, layer) -> {
            for (class_1921 renderLayer : ((VertexConsumerProvider_ImmediateAccessor)receiver).enchantOutline$getLayerBuffers().keySet()) {
                if (!((RenderLayerAccessor)renderLayer).enchantOutline$shouldDrawAfterCustom()) continue;
                receiver.method_22994(renderLayer);
            }
            return class_1269.field_5811;
        });
        BufferBuilderModifyReturnValue.EVENT.register(original -> {
            VertexConsumerProvider_ImmediateAccessor accessor = (VertexConsumerProvider_ImmediateAccessor)original;
            class_1921 enchantGlintLayer = EnchantmentGlintOutline.getTargetEnchantGlintLayer();
            class_1921 enchantColorLayer = EnchantmentGlintOutline.getTargetEnchantColorLayer();
            class_1921 enchantZFixLayer = EnchantmentGlintOutline.getTargetEnchantZFixLayer();
            SequencedMap<class_1921, class_9799> buffers = accessor.enchantOutline$getLayerBuffers();
            if (!Objects.equals(accessor.enchantOutline$getDirty(GLINT_LAYERS), GLINT_LAYERS.getDirty()) && buffers.containsKey(enchantGlintLayer) || !Objects.equals(accessor.enchantOutline$getDirty(COLOR_LAYERS), COLOR_LAYERS.getDirty()) && buffers.containsKey(enchantColorLayer) || !Objects.equals(accessor.enchantOutline$getDirty(ZFIX_LAYERS), ZFIX_LAYERS.getDirty()) && buffers.containsKey(enchantZFixLayer)) {
                accessor.enchantOutline$setDirty(GLINT_LAYERS, GLINT_LAYERS.getDirty());
                accessor.enchantOutline$setDirty(COLOR_LAYERS, COLOR_LAYERS.getDirty());
                accessor.enchantOutline$setDirty(ZFIX_LAYERS, ZFIX_LAYERS.getDirty());
                Object2ObjectLinkedOpenHashMap clonedBuffer = new Object2ObjectLinkedOpenHashMap(buffers);
                buffers.clear();
                for (Map.Entry set : clonedBuffer.entrySet()) {
                    if (GLINT_LAYERS.containsRenderLayer((class_1921)set.getKey()) || COLOR_LAYERS.containsRenderLayer((class_1921)set.getKey()) || ZFIX_LAYERS.containsRenderLayer((class_1921)set.getKey())) continue;
                    if (set.getKey() == enchantColorLayer) {
                        for (class_1921 layer : COLOR_LAYERS.renderLayers()) {
                            if (!((RenderLayerAccessor)layer).enchantOutline$shouldUseLayerBuffer()) continue;
                            buffers.put(layer, new class_9799(layer.method_22722()));
                        }
                    }
                    if (set.getKey() == Shaders.ARMOR_ENTITY_GLINT_FIX) {
                        enchantGlintLayer = Shaders.ARMOR_ENTITY_GLINT_FIX;
                    }
                    if (set.getKey() == enchantGlintLayer) {
                        for (class_1921 layer : GLINT_LAYERS.renderLayers()) {
                            if (!((RenderLayerAccessor)layer).enchantOutline$shouldUseLayerBuffer()) continue;
                            buffers.put(layer, new class_9799(layer.method_22722()));
                        }
                    }
                    if (set.getKey() == EnchantmentGlintOutline.getTargetEnchantGlintLayer()) {
                        buffers.put(Shaders.ARMOR_ENTITY_GLINT_FIX, new class_9799(Shaders.ARMOR_ENTITY_GLINT_FIX.method_22722()));
                    }
                    if (set.getKey() == enchantZFixLayer) {
                        for (class_1921 layer : ZFIX_LAYERS.renderLayers()) {
                            if (!((RenderLayerAccessor)layer).enchantOutline$shouldUseLayerBuffer()) continue;
                            buffers.put(layer, new class_9799(layer.method_22722()));
                        }
                    }
                    buffers.put((class_1921)set.getKey(), (class_9799)set.getValue());
                }
            }
            return null;
        });
        ItemModelManagerUpdateModelCallback.EVENT.register((receiver, model, itemRenderState, itemStack, itemModelManager, itemDisplayContext, clientWorld, heldItemContext, seed) -> {
            ((ItemRenderStateAccessor)itemRenderState).enchantOutline$setItemRendered(itemStack.method_7909());
            return class_1269.field_5811;
        });
        ItemRenderStateRenderLayerCallback.EVENT.register((receiver, layerRenderState, matrices, orderedRenderCommandQueue, light, overlay, i) -> {
            ((ItemRenderState_LayerRenderStateAccessor)layerRenderState).enchantOutline$setOwningItemRenderState(receiver);
            return class_1269.field_5811;
        });
        LayerRenderStateRenderSpecial.Callback.EVENT.register((receiver, specialModelRenderer, o, itemDisplayContext, matrixStack, orderedRenderCommandQueue, light, overlay, glint, i) -> {
            LAYER_RENDER_STATE_RENDER_MODEL_STORAGE.set(receiver);
            return class_1269.field_5811;
        });
        LayerRenderStateRenderSpecial.Post.EVENT.register((receiver, specialModelRenderer, o, itemDisplayContext, matrixStack, orderedRenderCommandQueue, light, overlay, glint, i) -> {
            LAYER_RENDER_STATE_RENDER_MODEL_STORAGE.remove();
            return class_1269.field_5811;
        });
    }

    private static void initLayers() {
        GLINT_LAYERS.addCustomRenderLayer(class_2960.method_60655((String)MOD_ID, (String)"cutoutlayer").toString(), Shaders.GLINT_CUTOUT_LAYER);
        COLOR_LAYERS.addCustomRenderLayer(class_2960.method_60655((String)MOD_ID, (String)"cutoutlayer").toString(), Shaders.COLOR_CUTOUT_LAYER);
        ZFIX_LAYERS.addCustomRenderLayer(class_2960.method_60655((String)MOD_ID, (String)"cutoutlayer").toString(), Shaders.ZFIX_CUTOUT_LAYER);
    }

    @Nullable
    ItemOverride getOverrideFromLayerRenderState(Function<String, @Nullable ItemOverride> overrideGetter, class_10444.class_10446 layerRenderState) {
        @Nullable class_10444 owningState = ((ItemRenderState_LayerRenderStateAccessor)layerRenderState).enchantOutline$getOwningRenderState();
        if (owningState != null) {
            @Nullable class_1792 renderedItem = ((ItemRenderStateAccessor)owningState).enchantOutline$getItemRendered();
            return this.getOverrideFromNullableItem(overrideGetter, renderedItem);
        }
        return null;
    }

    @Nullable
    ItemOverride getOverrideFromNullableItem(Function<String, @Nullable ItemOverride> overrideGetter, @Nullable class_1792 renderedItem) {
        class_2960 itemId;
        if (renderedItem != null && (itemId = class_7923.field_41178.method_10221((Object)renderedItem)) != null) {
            return (ItemOverride)overrideGetter.apply((Object)itemId.toString());
        }
        return null;
    }

    private static void loadConfig() {
        Path configFile = EnchantmentOutlineConfig.CONFIG_FILE;
        if (Files.exists(configFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                config = EnchantmentOutlineConfig.fromJson(reader);
            }
            catch (Exception e) {
                LOGGER.error("Error loading Enchantment Glint Outline config file. Default values will be used for this session.", (Throwable)e);
                config = new EnchantmentOutlineConfig();
            }
        } else {
            config = new EnchantmentOutlineConfig();
        }
        config.saveAsync();
    }

    static {
        LAYER_RENDER_STATE_RENDER_MODEL_STORAGE = new ThreadLocal();
    }
}

