/*
 * Decompiled with CFR 0.152.
 */
package net.enchantoutline.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.enchantoutline.EnchantmentGlintOutline;
import net.enchantoutline.config.ItemOverride;
import net.enchantoutline.config.ItemOverrideContainer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class EnchantmentOutlineConfig {
    public static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("enchantment-glint-outline.json");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final float MAX_OUTLINE_SIZE = 30.0f;
    public boolean enabled = true;
    public float outline_size = 20.0f;
    public boolean render_solid = false;
    public int[] render_solid_outline_color_rgb = new int[]{210, 150, 248};
    public boolean render_equipment = true;
    public float equipment_outline_size = 20.0f;
    public boolean render_equipment_solid = false;
    public Map<String, ItemOverride> item_overrides = new HashMap<String, ItemOverride>();
    public Map<String, ItemOverride> equipment_overrides = new HashMap<String, ItemOverride>();
    public Map<String, ItemOverride> overrides;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setOutlineSize(float outlineSize) {
        this.outline_size = outlineSize;
    }

    public float getOutlineSize() {
        return this.outline_size;
    }

    public void setRenderSolid(boolean renderSolid) {
        this.render_solid = renderSolid;
    }

    public boolean shouldRenderSolid() {
        return this.render_solid;
    }

    public int[] getOutlineColor() {
        return this.render_solid_outline_color_rgb;
    }

    public void setBaseSolidOutlineColor(int[] color) {
        this.render_solid_outline_color_rgb = color;
    }

    public void setBaseSolidOutlineColorAsInt(int color) {
        color = class_9848.method_61330((int)255, (int)color);
        int[] newOutlineColor = new int[]{class_9848.method_61327((int)color), class_9848.method_61329((int)color), class_9848.method_61331((int)color)};
        this.render_solid_outline_color_rgb = newOutlineColor;
    }

    public int getOutlineColorAsInt(int[] outlineColorInt) {
        if (outlineColorInt.length < 3) {
            return -1;
        }
        return class_9848.method_61330((int)255, (int)class_9848.method_61323((int)outlineColorInt[0], (int)outlineColorInt[1], (int)outlineColorInt[2]));
    }

    public void setRenderArmor(boolean renderArmor) {
        this.render_equipment = renderArmor;
    }

    public boolean shouldRenderArmor() {
        return this.render_equipment;
    }

    public void setArmorOutlineSize(float armorOutlineSize) {
        this.equipment_outline_size = armorOutlineSize;
    }

    public float getArmorOutlineSize() {
        return this.equipment_outline_size;
    }

    public void setRenderArmorSolid(boolean renderArmorSolid) {
        this.render_equipment_solid = renderArmorSolid;
    }

    public boolean shouldRenderArmorSolid() {
        return this.render_equipment_solid;
    }

    public void setItemOverrides(Map<String, ItemOverride> item_overrides) {
        this.item_overrides = item_overrides;
    }

    public Map<String, ItemOverride> getItemOverrides() {
        return this.item_overrides;
    }

    public void setItemOverridesFromContainerList(List<ItemOverrideContainer> overrideList) {
        HashMap<String, ItemOverride> newOverrides = new HashMap<String, ItemOverride>(overrideList.size());
        for (ItemOverrideContainer itemOverrideContainer : overrideList) {
            newOverrides.put(itemOverrideContainer.getItemString(), itemOverrideContainer.getItemOverride());
        }
        this.setItemOverrides(newOverrides);
    }

    public List<ItemOverrideContainer> getItemOverridesAsContainerList() {
        ArrayList<ItemOverrideContainer> overrideList = new ArrayList<ItemOverrideContainer>(this.getItemOverrides().size());
        for (Map.Entry<String, ItemOverride> set : this.getItemOverrides().entrySet()) {
            overrideList.add(new ItemOverrideContainer(set.getKey(), set.getValue()));
        }
        return overrideList;
    }

    public void setArmorOverrides(Map<String, ItemOverride> armor_overrides) {
        this.equipment_overrides = armor_overrides;
    }

    public Map<String, ItemOverride> getArmorOverrides() {
        return this.equipment_overrides;
    }

    public void setArmorOverridesFromContainerList(List<ItemOverrideContainer> overrideList) {
        HashMap<String, ItemOverride> newOverrides = new HashMap<String, ItemOverride>(overrideList.size());
        for (ItemOverrideContainer itemOverrideContainer : overrideList) {
            newOverrides.put(itemOverrideContainer.getItemString(), itemOverrideContainer.getItemOverride());
        }
        this.setArmorOverrides(newOverrides);
    }

    public List<ItemOverrideContainer> getArmorOverridesAsContainerList() {
        ArrayList<ItemOverrideContainer> overrideList = new ArrayList<ItemOverrideContainer>(this.getArmorOverrides().size());
        for (Map.Entry<String, ItemOverride> set : this.getArmorOverrides().entrySet()) {
            overrideList.add(new ItemOverrideContainer(set.getKey(), set.getValue()));
        }
        return overrideList;
    }

    @Nullable
    public ItemOverride getItemOverride(Object item) {
        return this.item_overrides.get(item);
    }

    @Nullable
    public ItemOverride getArmorOverride(Object item) {
        return this.equipment_overrides.get(item);
    }

    public static int[] getIntFromColor(Color color) {
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    public static Color getColorFromInt(int[] intColor) {
        return new Color(intColor[0], intColor[1], intColor[2], 255);
    }

    public float getScaleFactorFromOutlineSize(float outlineSize) {
        return outlineSize / 1000.0f;
    }

    public float getOutlineSizeOverrideOrDefault(ItemOverride override, boolean armor) {
        if (override != null && override.shouldOverrideOutlineSize()) {
            return override.getOutlineSize();
        }
        return armor ? this.getArmorOutlineSize() : this.getOutlineSize();
    }

    public boolean getRenderSolidOverrideOrDefault(ItemOverride override, boolean armor) {
        if (override != null && override.shouldOverrideRenderSolid()) {
            return override.shouldRenderSolid();
        }
        return armor ? this.shouldRenderArmorSolid() : this.shouldRenderSolid();
    }

    public int[] getOutlineColorOverrideOrDefault(ItemOverride override) {
        if (override != null && override.shouldOverrideRenderSolidOutlineColor()) {
            return override.getRenderSolidOutlineColor();
        }
        return this.getOutlineColor();
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public static EnchantmentOutlineConfig fromJson(String json) {
        return (EnchantmentOutlineConfig)GSON.fromJson(json, EnchantmentOutlineConfig.class);
    }

    public static EnchantmentOutlineConfig fromJson(Reader reader) {
        return (EnchantmentOutlineConfig)GSON.fromJson(reader, EnchantmentOutlineConfig.class);
    }

    public CompletableFuture<Void> saveAsync() {
        return CompletableFuture.runAsync(() -> {
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE, new OpenOption[0]);){
                writer.write(this.toJson());
            }
            catch (Exception e) {
                EnchantmentGlintOutline.LOGGER.error("Error saving Enchant Glint Outline config.", (Throwable)e);
                throw new CompletionException(e);
            }
        });
    }
}

