/*
 * Decompiled with CFR 0.152.
 */
package net.enchantoutline.util;

import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class VertexHelper {
    public static Vector3f[] getVertexPos(int[] vertexData) {
        Vertex[] outVerts = VertexHelper.getVertexData(vertexData);
        Vector3f[] returnList = new Vector3f[outVerts.length];
        for (int i = 0; i < outVerts.length; ++i) {
            returnList[i] = outVerts[i].pos();
        }
        return returnList;
    }

    public static Vertex[] getVertexData(int[] vertexData) {
        int vertices = vertexData.length / 8;
        Vertex[] returnList = new Vertex[vertices];
        for (int i = 0; i < vertices; ++i) {
            int vertStride = i * 8;
            Vector3f vertPos = new Vector3f(Float.intBitsToFloat(vertexData[vertStride]), Float.intBitsToFloat(vertexData[vertStride + 1]), Float.intBitsToFloat(vertexData[vertStride + 2]));
            float u = Float.intBitsToFloat(vertexData[vertStride + 4]);
            float v = Float.intBitsToFloat(vertexData[vertStride + 5]);
            returnList[i] = new Vertex(vertPos, u, v);
        }
        return returnList;
    }

    public static void setVertexData(int[] outVertexData, Vector3f[] newPos) {
        int vertices = outVertexData.length / 8;
        for (int i = 0; i < vertices; ++i) {
            int vertStride = i * 8;
            outVertexData[vertStride] = Float.floatToIntBits(newPos[i].x);
            outVertexData[vertStride + 1] = Float.floatToIntBits(newPos[i].y);
            outVertexData[vertStride + 2] = Float.floatToIntBits(newPos[i].z);
        }
    }

    public static int[] flip(int[] inVertexData) {
        int vertices = inVertexData.length / 8;
        int[] outVertextData = new int[inVertexData.length];
        for (int i = 0; i < vertices; ++i) {
            int stride = 8;
            System.arraycopy(inVertexData, i * stride, outVertextData, (vertices - i - 1) * stride, stride);
        }
        return outVertextData;
    }

    public static Vector3f[] getFaceCardinalDirs(Vector3f[] quadVerts, float scale) {
        if (quadVerts.length == 4) {
            Vector3f center = new Vector3f();
            for (Vector3f vert : quadVerts) {
                center.add((Vector3fc)vert);
            }
            center.div((float)quadVerts.length);
            Vector3f corner1 = quadVerts[0];
            Vector3f corner2 = quadVerts[1];
            corner1.sub((Vector3fc)center);
            corner2.sub((Vector3fc)center);
            Vector3f side1 = new Vector3f((Vector3fc)corner1);
            side1.add((Vector3fc)corner2);
            Vector3f side2 = new Vector3f((Vector3fc)corner1);
            side2.sub((Vector3fc)corner2);
            side1.normalize();
            side2.normalize();
            Vector3f localDiagonal = side1;
            localDiagonal.add((Vector3fc)side2);
            localDiagonal.mul(scale);
            Vector3f otherLocal = new Vector3f((Vector3fc)localDiagonal).reflect((Vector3fc)side2);
            Vector3f[] cardinalDirs = new Vector3f[]{new Vector3f((Vector3fc)localDiagonal), new Vector3f((Vector3fc)otherLocal), localDiagonal.mul(-1.0f), otherLocal.mul(-1.0f)};
            corner1.add((Vector3fc)center);
            corner2.add((Vector3fc)center);
            return cardinalDirs;
        }
        return null;
    }

    public static Vector3f[] growFace(Vector3f[] defaultVerts, Vector3f cardinalDir, Vector3f scaledNormal) {
        Vector3f[] vertPoses = new Vector3f[defaultVerts.length];
        Vector3f normalizedNormal = new Vector3f((Vector3fc)scaledNormal);
        normalizedNormal.normalize();
        normalizedNormal.mul(1.0E-4f);
        scaledNormal.add((Vector3fc)normalizedNormal);
        for (int vertInterator = 0; vertInterator < defaultVerts.length; ++vertInterator) {
            Vector3f vert = new Vector3f((Vector3fc)defaultVerts[vertInterator]);
            vert.add((Vector3fc)scaledNormal);
            vert.add((Vector3fc)cardinalDir);
            vertPoses[vertInterator] = vert;
        }
        return vertPoses;
    }

    public static Vector3f growVert(Vector3f pos, Vector3f cardinalDir, Vector3f scaledNormal) {
        Vector3f normalizedNormal = new Vector3f((Vector3fc)scaledNormal);
        normalizedNormal.normalize();
        normalizedNormal.mul(1.0E-4f);
        scaledNormal.add((Vector3fc)normalizedNormal);
        Vector3f vert = new Vector3f((Vector3fc)pos);
        vert.add((Vector3fc)scaledNormal);
        vert.add((Vector3fc)cardinalDir);
        return vert;
    }

    public static Vector3f transformVector(class_4587 matrices, Vector3f vec) {
        Matrix4f mat = matrices.method_23760().method_23761();
        Vector4f vec4 = new Vector4f(vec.x(), vec.y(), vec.z(), 1.0f);
        mat.transform(vec4);
        return new Vector3f(vec4.x(), vec4.y(), vec4.z());
    }

    public static void packVertexData(int[] vertices, int cornerIndex, Vector3f pos, float u, float v) {
        int i = cornerIndex * 8;
        vertices[i] = Float.floatToRawIntBits(pos.x());
        vertices[i + 1] = Float.floatToRawIntBits(pos.y());
        vertices[i + 2] = Float.floatToRawIntBits(pos.z());
        vertices[i + 3] = -1;
        vertices[i + 4] = Float.floatToRawIntBits(u);
        vertices[i + 4 + 1] = Float.floatToRawIntBits(v);
    }

    public record Vertex(Vector3f pos, float u, float v) {
    }
}

