/*
 * Decompiled with CFR 0.152.
 */
package net.sorasetsuna.minecartqol.events;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="minecartqol")
public class MinecartPickupHandler {
    @SubscribeEvent
    public static void onMinecartShiftRightClick(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!event.getTarget().getClass().equals(Minecart.class)) {
            return;
        }
        AbstractMinecart minecart = (AbstractMinecart)event.getTarget();
        Player player = event.getEntity();
        Level level = event.getLevel();
        if (!player.isShiftKeyDown()) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        if (!level.isClientSide) {
            ItemStack minecartStack = new ItemStack((ItemLike)Items.MINECART);
            boolean added = player.getInventory().add(minecartStack);
            if (!added) {
                ItemEntity itemEntity = new ItemEntity(level, minecart.getX(), minecart.getY(), minecart.getZ(), minecartStack);
                level.addFreshEntity((Entity)itemEntity);
            }
            minecart.discard();
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, player.getSoundSource(), 1.0f, 1.0f);
        }
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }
}

