/*
 * Decompiled with CFR 0.152.
 */
package net.sorasetsuna.minecartqol.block.custom;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.Vec3;
import net.sorasetsuna.minecartqol.config.ModCommonConfigs;
import org.jetbrains.annotations.Nullable;

public class LightningRailBlock
extends RailBlock {
    public LightningRailBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        if (!level.isClientSide) {
            Vec3 motion = cart.getDeltaMovement();
            double horizontalSpeed = motion.horizontalDistance();
            double boostAmount = (Double)ModCommonConfigs.LIGHTNING_RAIL_BOOST_AMOUNT.get();
            if (horizontalSpeed > 0.01) {
                Vec3 boosted = motion.add(motion.x / horizontalSpeed * boostAmount, 0.0, motion.z / horizontalSpeed * boostAmount);
                cart.setDeltaMovement(boosted);
                cart.move(MoverType.SELF, boosted);
            }
            cart.setMaxSpeedAirLateral(((Double)ModCommonConfigs.LIGHTNING_RAIL_MAX_SPEED_AIR_LATERAL.get()).floatValue());
            cart.setMaxSpeedAirVertical(((Double)ModCommonConfigs.LIGHTNING_RAIL_MAX_SPEED_AIR_VERTICAL.get()).floatValue());
            cart.setDragAir(1.0);
            Vec3 velocity = cart.getDeltaMovement();
            double speed = velocity.horizontalDistance();
            if (speed > (Double)ModCommonConfigs.LIGHTNING_RAIL_SPEED_CHECK.get()) {
                Vec3 clamped = new Vec3(velocity.x, 0.0, velocity.z).normalize().scale(((Double)ModCommonConfigs.LIGHTNING_RAIL_SPEED_CHECK.get()).doubleValue());
                cart.setDeltaMovement(clamped.x, velocity.y, clamped.z);
            }
        }
    }

    public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        return ((Double)ModCommonConfigs.LIGHTNING_RAIL_MAX_SPEED_GENERAL.get()).floatValue();
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return List.of(new ItemStack((ItemLike)this));
    }

    public void appendHoverText(ItemStack pStack, @Nullable Item.TooltipContext pContext, List<Component> pTooltip, TooltipFlag pFlag) {
        if (Screen.hasShiftDown()) {
            pTooltip.add((Component)Component.translatable((String)"tooltip.minecartqol.shift1"));
            pTooltip.add((Component)Component.translatable((String)"tooltip.minecartqol.shift2"));
            pTooltip.add((Component)Component.translatable((String)"tooltip.minecartqol.shift4b"));
            pTooltip.add((Component)Component.translatable((String)"tooltip.minecartqol.shift4c"));
            pTooltip.add((Component)Component.translatable((String)"tooltip.minecartqol.shift.separator"));
            pTooltip.add((Component)Component.translatable((String)"tooltip.minecartqol.shift.addon1"));
            pTooltip.add((Component)Component.translatable((String)"tooltip.minecartqol.shift.addon2"));
            pTooltip.add((Component)Component.translatable((String)"tooltip.minecartqol.shift.addon3"));
        } else {
            pTooltip.add((Component)Component.translatable((String)"tooltip.minecartqol.tooltip"));
        }
        super.appendHoverText(pStack, pContext, pTooltip, pFlag);
    }
}

