/*
 * Decompiled with CFR 0.152.
 */
package net.sorasetsuna.minecartqol.block.custom;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AlwaysPoweredRailBlock
extends RailBlock {
    public AlwaysPoweredRailBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.7f).m_60953_(state -> 15));
    }

    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        if (!level.f_46443_) {
            Vec3 motion = cart.m_20184_();
            double horizontalSpeed = motion.m_165924_();
            double boostAmount = 0.7;
            double upwardBoost = 0.7;
            RailShape shape = (RailShape)state.m_61143_(this.m_7978_());
            Vec3 boosted = motion;
            if (horizontalSpeed > 0.01) {
                boosted = boosted.m_82520_(motion.f_82479_ / horizontalSpeed * boostAmount, 0.0, motion.f_82481_ / horizontalSpeed * boostAmount);
                if (this.isAscending(shape)) {
                    boosted = boosted.m_82520_(0.0, upwardBoost, 0.0);
                }
            } else if (this.isAscending(shape)) {
                boosted = this.getSlopeDirection(shape).m_82490_(0.05).m_82520_(0.0, 0.05, 0.0);
            }
            cart.m_20256_(boosted);
            double maxSpeed = 0.7;
            double speed = cart.m_20184_().m_165924_();
            if (speed > maxSpeed) {
                Vec3 clamped = new Vec3(cart.m_20184_().f_82479_, 0.0, cart.m_20184_().f_82481_).m_82541_().m_82490_(maxSpeed);
                cart.m_20334_(clamped.f_82479_, cart.m_20184_().f_82480_, clamped.f_82481_);
            }
        }
    }

    private boolean isAscending(RailShape shape) {
        return switch (shape) {
            case RailShape.ASCENDING_EAST, RailShape.ASCENDING_WEST, RailShape.ASCENDING_NORTH, RailShape.ASCENDING_SOUTH -> true;
            default -> false;
        };
    }

    private Vec3 getSlopeDirection(RailShape shape) {
        return switch (shape) {
            case RailShape.ASCENDING_EAST -> new Vec3(1.0, 0.0, 0.0);
            case RailShape.ASCENDING_WEST -> new Vec3(-1.0, 0.0, 0.0);
            case RailShape.ASCENDING_NORTH -> new Vec3(0.0, 0.0, -1.0);
            case RailShape.ASCENDING_SOUTH -> new Vec3(0.0, 0.0, 1.0);
            default -> Vec3.f_82478_;
        };
    }

    public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        return 0.6f;
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        if (Screen.m_96638_()) {
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.shift1"));
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.shift2"));
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.shift3"));
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.shift4a"));
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.shift.separator"));
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.shift.addon1"));
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.shift.addon2"));
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.shift.addon3"));
        } else {
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.tooltip"));
        }
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }
}

