/*
 * Decompiled with CFR 0.152.
 */
package net.sorasetsuna.minecartqol.block.custom;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.sorasetsuna.minecartqol.config.ModCommonConfigs;
import org.jetbrains.annotations.Nullable;

public class LightningRailBlock
extends RailBlock {
    public LightningRailBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.7f).m_60953_(state -> 15));
    }

    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        if (!level.f_46443_) {
            Vec3 motion = cart.m_20184_();
            double horizontalSpeed = motion.m_165924_();
            double boostAmount = (Double)ModCommonConfigs.LIGHTNING_RAIL_BOOST_AMOUNT.get();
            if (horizontalSpeed > 0.01) {
                Vec3 boosted = motion.m_82520_(motion.f_82479_ / horizontalSpeed * boostAmount, 0.0, motion.f_82481_ / horizontalSpeed * boostAmount);
                cart.m_20256_(boosted);
                cart.m_6478_(MoverType.SELF, boosted);
            }
            cart.setMaxSpeedAirLateral(((Double)ModCommonConfigs.LIGHTNING_RAIL_MAX_SPEED_AIR_LATERAL.get()).floatValue());
            cart.setMaxSpeedAirVertical(((Double)ModCommonConfigs.LIGHTNING_RAIL_MAX_SPEED_AIR_VERTICAL.get()).floatValue());
            cart.setDragAir(1.0);
            Vec3 velocity = cart.m_20184_();
            double speed = velocity.m_165924_();
            if (speed > (Double)ModCommonConfigs.LIGHTNING_RAIL_SPEED_CHECK.get()) {
                Vec3 clamped = new Vec3(velocity.f_82479_, 0.0, velocity.f_82481_).m_82541_().m_82490_(((Double)ModCommonConfigs.LIGHTNING_RAIL_SPEED_CHECK.get()).doubleValue());
                cart.m_20334_(clamped.f_82479_, velocity.f_82480_, clamped.f_82481_);
            }
        }
    }

    public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        return ((Double)ModCommonConfigs.LIGHTNING_RAIL_MAX_SPEED_GENERAL.get()).floatValue();
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        if (Screen.m_96638_()) {
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.shift1"));
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.shift2"));
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.shift4b"));
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.shift4c"));
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.shift.separator"));
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.shift.addon1"));
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.shift.addon2"));
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.shift.addon3"));
        } else {
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.minecartqol.tooltip"));
        }
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }
}

