/*
 * Decompiled with CFR 0.152.
 */
package net.sorasetsuna.minecartqol.block.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeBaseRailBlock;

public class AlwaysPoweredRailBlock
extends RailBlock
implements IForgeBaseRailBlock {
    public AlwaysPoweredRailBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        if (!level.isClientSide) {
            Vec3 motion = cart.getDeltaMovement();
            double horizontalSpeed = motion.horizontalDistance();
            double boostAmount = 0.7;
            double upwardBoost = 0.7;
            RailShape shape = (RailShape)state.getValue(this.getShapeProperty());
            Vec3 boosted = motion;
            if (horizontalSpeed > 0.01) {
                boosted = boosted.add(motion.x / horizontalSpeed * boostAmount, 0.0, motion.z / horizontalSpeed * boostAmount);
                if (this.isAscending(shape)) {
                    boosted = boosted.add(0.0, upwardBoost, 0.0);
                }
            } else if (this.isAscending(shape)) {
                boosted = this.getSlopeDirection(shape).scale(0.05).add(0.0, 0.05, 0.0);
            }
            cart.setDeltaMovement(boosted);
            double maxSpeed = 0.7;
            double speed = cart.getDeltaMovement().horizontalDistance();
            if (speed > maxSpeed) {
                Vec3 clamped = new Vec3(cart.getDeltaMovement().x, 0.0, cart.getDeltaMovement().z).normalize().scale(maxSpeed);
                cart.setDeltaMovement(clamped.x, cart.getDeltaMovement().y, clamped.z);
            }
        }
    }

    private boolean isAscending(RailShape shape) {
        return switch (shape) {
            case RailShape.ASCENDING_EAST, RailShape.ASCENDING_WEST, RailShape.ASCENDING_NORTH, RailShape.ASCENDING_SOUTH -> true;
            default -> false;
        };
    }

    private Vec3 getSlopeDirection(RailShape shape) {
        return switch (shape) {
            case RailShape.ASCENDING_EAST -> new Vec3(1.0, 0.0, 0.0);
            case RailShape.ASCENDING_WEST -> new Vec3(-1.0, 0.0, 0.0);
            case RailShape.ASCENDING_NORTH -> new Vec3(0.0, 0.0, -1.0);
            case RailShape.ASCENDING_SOUTH -> new Vec3(0.0, 0.0, 1.0);
            default -> Vec3.ZERO;
        };
    }

    public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        return 0.7f;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return List.of(new ItemStack((ItemLike)this));
    }
}

