/*
 * Decompiled with CFR 0.152.
 */
package net.sorasetsuna.minecartqol.block;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.sorasetsuna.minecartqol.block.custom.AlwaysPoweredRailBlock;
import net.sorasetsuna.minecartqol.block.custom.LightningRailBlock;
import net.sorasetsuna.minecartqol.item.ModItems;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"minecartqol");
    public static final RegistryObject<Block> ALWAYS_POWERED_RAIL = ModBlocks.registerBlock("always_powered_rail", () -> new AlwaysPoweredRailBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RAIL).lightLevel(state -> 15).noCollission().strength(0.7f).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecartqol", (String)"minecartqol")))));
    public static final RegistryObject<Block> LIGHTNING_RAIL = ModBlocks.registerBlock("lightning_rail", () -> new LightningRailBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RAIL).lightLevel(state -> 15).noCollission().strength(0.7f).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecartqol", (String)"minecartqol")))));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().useBlockDescriptionPrefix().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecartqol", (String)name)))));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

