/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosbetterglassmod.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.sarocesch.sarosbetterglassmod.client.model.GlassShardModel;
import de.sarocesch.sarosbetterglassmod.entity.GlassShardEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;

public class GlassShardRenderer
extends EntityRenderer<GlassShardEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "textures/block/glass.png");
    private static final ResourceLocation TEXTURE_TINTED = new ResourceLocation("minecraft", "textures/block/white_stained_glass.png");
    private final GlassShardModel model;

    public GlassShardRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.0f;
        this.model = new GlassShardModel(context.m_174023_(GlassShardModel.LAYER_LOCATION));
    }

    public void render(GlassShardEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.8f, 0.8f, 0.8f);
        long entityId = entity.m_19879_();
        float rotX = entityId * 127L % 360L;
        float rotY = entityId * 237L % 360L;
        float rotZ = entityId * 347L % 360L;
        poseStack.m_252781_(Axis.f_252529_.m_252977_(rotX));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotY));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotZ));
        int glassType = entity.getGlassType();
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 0.9f;
        Block sourceBlock = entity.getSourceBlock();
        if (glassType > 0) {
            switch (glassType % 100) {
                case 1: {
                    r = 1.0f;
                    g = 1.0f;
                    b = 1.0f;
                    break;
                }
                case 2: {
                    r = 1.0f;
                    g = 0.5f;
                    b = 0.0f;
                    break;
                }
                case 3: {
                    r = 0.9f;
                    g = 0.3f;
                    b = 0.9f;
                    break;
                }
                case 4: {
                    r = 0.4f;
                    g = 0.6f;
                    b = 0.9f;
                    break;
                }
                case 5: {
                    r = 1.0f;
                    g = 0.9f;
                    b = 0.0f;
                    break;
                }
                case 6: {
                    r = 0.4f;
                    g = 0.9f;
                    b = 0.0f;
                    break;
                }
                case 7: {
                    r = 1.0f;
                    g = 0.7f;
                    b = 0.8f;
                    break;
                }
                case 8: {
                    r = 0.3f;
                    g = 0.3f;
                    b = 0.3f;
                    break;
                }
                case 9: {
                    r = 0.7f;
                    g = 0.7f;
                    b = 0.7f;
                    break;
                }
                case 10: {
                    r = 0.0f;
                    g = 0.8f;
                    b = 0.8f;
                    break;
                }
                case 11: {
                    r = 0.6f;
                    g = 0.0f;
                    b = 0.8f;
                    break;
                }
                case 12: {
                    r = 0.0f;
                    g = 0.0f;
                    b = 1.0f;
                    break;
                }
                case 13: {
                    r = 0.5f;
                    g = 0.3f;
                    b = 0.1f;
                    break;
                }
                case 14: {
                    r = 0.0f;
                    g = 0.6f;
                    b = 0.0f;
                    break;
                }
                case 15: {
                    r = 1.0f;
                    g = 0.0f;
                    b = 0.0f;
                    break;
                }
                case 16: {
                    r = 0.1f;
                    g = 0.1f;
                    b = 0.1f;
                    break;
                }
                case 17: {
                    r = 0.3f;
                    g = 0.3f;
                    b = 0.4f;
                    a = 0.7f;
                }
            }
            if (glassType >= 100) {
                a -= 0.1f;
            }
        }
        float fadeAlpha = Mth.m_14036_((float)((float)entity.getLifetime() / 20.0f), (float)0.0f, (float)1.0f);
        ResourceLocation texture = this.getTextureLocation(entity);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110470_((ResourceLocation)texture));
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, r, g, b, a *= fadeAlpha);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(GlassShardEntity entity) {
        int glassType = entity.getGlassType();
        Block sourceBlock = entity.getSourceBlock();
        if (glassType > 0) {
            if (glassType == 17) {
                return TEXTURE_TINTED;
            }
            return TEXTURE_TINTED;
        }
        return TEXTURE;
    }
}

