/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosbetterglassmod.compat;

import de.sarocesch.sarosbetterglassmod.SarosBetterGlassMod;
import de.sarocesch.sarosbetterglassmod.listener.GlassBreakListener;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;

public final class TacZGlassCompatHandler {
    public static void init() {
        if (ModList.get().isLoaded("tacz")) {
            try {
                Class<?> ammoHitBlockEventClass = Class.forName("com.tacz.guns.api.event.server.AmmoHitBlockEvent");
                MinecraftForge.EVENT_BUS.addListener(event -> {
                    if (ammoHitBlockEventClass.isInstance(event)) {
                        try {
                            Level level = (Level)event.getClass().getMethod("getLevel", new Class[0]).invoke(event, new Object[0]);
                            Object hitResult = event.getClass().getMethod("getHitResult", new Class[0]).invoke(event, new Object[0]);
                            BlockPos pos = (BlockPos)hitResult.getClass().getMethod("getBlockPos", new Class[0]).invoke(hitResult, new Object[0]);
                            Object ammo = event.getClass().getMethod("getAmmo", new Class[0]).invoke(event, new Object[0]);
                            Entity shooter = (Entity)ammo.getClass().getMethod("getOwner", new Class[0]).invoke(ammo, new Object[0]);
                            GlassBreakListener.handleGlassBreak(level, pos, null, shooter);
                        }
                        catch (Exception e) {
                            SarosBetterGlassMod.LOGGER.error("Error while processing AmmoHitBlockEvent", (Throwable)e);
                        }
                    }
                });
                SarosBetterGlassMod.LOGGER.info("TACZ Guns compatibility initialized successfully.");
            }
            catch (ClassNotFoundException e) {
                SarosBetterGlassMod.LOGGER.info("TACZ Guns mod not found, disabling TACZ compatibility.");
            }
        }
    }

    private TacZGlassCompatHandler() {
    }
}

