/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosbetterglassmod.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="sarosbetterglassmod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue ENABLE_TAC_WEAPON_GLASS_BREAKING = BUILDER.comment("Enable TAC-Zero weapons breaking glass using the Saros system instead of vanilla/weapon logic").define("enableTacWeaponGlassBreaking", true);
    private static final ForgeConfigSpec.BooleanValue ENABLE_ARROW_GLASS_BREAKING = BUILDER.comment("Enable arrows breaking glass when they hit it").define("enableArrowGlassBreaking", true);
    private static final ForgeConfigSpec.BooleanValue ENABLE_ANVIL_GLASS_BREAKING = BUILDER.comment("Enable anvils breaking glass when they fall on it").define("enableAnvilGlassBreaking", true);
    private static final ForgeConfigSpec.BooleanValue ENABLE_MODDED_GLASS_SUPPORT = BUILDER.comment("Enable support for modded glass blocks").define("enableModdedGlassSupport", true);
    private static final ForgeConfigSpec.BooleanValue ENABLE_GLASS_SHARDS = BUILDER.comment("Enable glass shards when glass breaks").define("enableGlassShards", true);
    private static final ForgeConfigSpec.IntValue GLASS_SHARD_COUNT = BUILDER.comment("Number of glass shards to spawn when glass breaks").defineInRange("glassShardCount", 23, 1, 30);
    private static final ForgeConfigSpec.DoubleValue GLASS_SHARD_FRICTION = BUILDER.comment("Friction factor for glass shards (higher = less sliding)").defineInRange("glassShardFriction", 0.7, 0.1, 1.0);
    private static final ForgeConfigSpec.IntValue GLASS_SHARD_LIFETIME = BUILDER.comment("Lifetime of glass shards in ticks (20 ticks = 1 second)").defineInRange("glassShardLifetime", 200, 20, 6000);
    private static final ForgeConfigSpec.IntValue GLASS_SHARD_GROUND_TIME = BUILDER.comment("Time in ticks that glass shards stay on the ground before despawning (20 ticks = 1 second)").defineInRange("glassShardGroundTime", 100, 20, 1200);
    private static final ForgeConfigSpec.BooleanValue ENABLE_MINING_GLASS_SHARDS = BUILDER.comment("Enable glass shards when mining glass blocks").define("enableMiningGlassShards", true);
    private static final ForgeConfigSpec.BooleanValue ENABLE_EXPLOSION_GLASS_SHARDS = BUILDER.comment("Enable glass shards when glass blocks are destroyed by explosions").define("enableExplosionGlassShards", true);
    private static final ForgeConfigSpec.BooleanValue ENABLE_ENTITY_GLASS_BREAKING = BUILDER.comment("Enable entities breaking through glass when they would take enough damage").define("enableEntityGlassBreaking", true);
    private static final ForgeConfigSpec.DoubleValue ENTITY_GLASS_BREAKING_THRESHOLD = BUILDER.comment("Minimum damage (in hearts) an entity needs to take to break through glass").defineInRange("entityGlassBreakingThreshold", 2.0, 0.5, 10.0);
    private static final ForgeConfigSpec.BooleanValue ENABLE_GLASS_SHARD_DAMAGE = BUILDER.comment("Enable damage when entities step on glass shards").define("enableGlassShardDamage", true);
    private static final ForgeConfigSpec.DoubleValue GLASS_SHARD_DAMAGE_AMOUNT = BUILDER.comment("Amount of damage (in half hearts) entities take when stepping on glass shards").defineInRange("glassShardDamageAmount", 1.0, 0.5, 5.0);
    private static final ForgeConfigSpec.BooleanValue SHOES_PROTECT_FROM_GLASS = BUILDER.comment("Whether wearing any type of boots protects from glass shard damage").define("shoesProtectFromGlass", true);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean enableTacWeaponGlassBreaking;
    public static boolean enableArrowGlassBreaking;
    public static boolean enableAnvilGlassBreaking;
    public static boolean enableModdedGlassSupport;
    public static boolean enableGlassShards;
    public static int glassShardCount;
    public static double glassShardFriction;
    public static int glassShardLifetime;
    public static int glassShardGroundTime;
    public static boolean enableMiningGlassShards;
    public static boolean enableExplosionGlassShards;
    public static boolean enableEntityGlassBreaking;
    public static double entityGlassBreakingThreshold;
    public static boolean enableGlassShardDamage;
    public static double glassShardDamageAmount;
    public static boolean shoesProtectFromGlass;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent event) {
        enableTacWeaponGlassBreaking = (Boolean)ENABLE_TAC_WEAPON_GLASS_BREAKING.get();
        enableArrowGlassBreaking = (Boolean)ENABLE_ARROW_GLASS_BREAKING.get();
        enableAnvilGlassBreaking = (Boolean)ENABLE_ANVIL_GLASS_BREAKING.get();
        enableModdedGlassSupport = (Boolean)ENABLE_MODDED_GLASS_SUPPORT.get();
        enableGlassShards = (Boolean)ENABLE_GLASS_SHARDS.get();
        glassShardCount = (Integer)GLASS_SHARD_COUNT.get();
        glassShardFriction = (Double)GLASS_SHARD_FRICTION.get();
        glassShardLifetime = (Integer)GLASS_SHARD_LIFETIME.get();
        glassShardGroundTime = (Integer)GLASS_SHARD_GROUND_TIME.get();
        enableMiningGlassShards = (Boolean)ENABLE_MINING_GLASS_SHARDS.get();
        enableExplosionGlassShards = (Boolean)ENABLE_EXPLOSION_GLASS_SHARDS.get();
        enableEntityGlassBreaking = (Boolean)ENABLE_ENTITY_GLASS_BREAKING.get();
        entityGlassBreakingThreshold = (Double)ENTITY_GLASS_BREAKING_THRESHOLD.get();
        enableGlassShardDamage = (Boolean)ENABLE_GLASS_SHARD_DAMAGE.get();
        glassShardDamageAmount = (Double)GLASS_SHARD_DAMAGE_AMOUNT.get();
        shoesProtectFromGlass = (Boolean)SHOES_PROTECT_FROM_GLASS.get();
    }
}

