/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosbetterglassmod.entity;

import de.sarocesch.sarosbetterglassmod.config.ModConfig;
import de.sarocesch.sarosbetterglassmod.entity.ModEntityTypes;
import de.sarocesch.sarosbetterglassmod.util.ModDamageSources;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GlassShardEntity
extends Entity {
    private static final EntityDataAccessor<Integer> GLASS_TYPE = SynchedEntityData.m_135353_(GlassShardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.m_135353_(GlassShardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ON_GROUND_SHARD = SynchedEntityData.m_135353_(GlassShardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean settled = false;
    private int groundTime = 0;
    private Block sourceBlock = Blocks.f_50058_;

    public GlassShardEntity(EntityType<? extends GlassShardEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = false;
        this.m_20242_(false);
        this.m_20331_(true);
        this.m_20225_(true);
    }

    public GlassShardEntity(Level level, double x, double y, double z, Block glassBlock) {
        this((EntityType<? extends GlassShardEntity>)((EntityType)ModEntityTypes.GLASS_SHARD.get()), level);
        this.m_6034_(x, y, z);
        this.sourceBlock = glassBlock;
        this.setGlassType(this.getGlassTypeId(glassBlock));
        this.setLifetime(ModConfig.glassShardLifetime);
        double motionX = level.f_46441_.m_188500_() * 0.2 - 0.1;
        double motionY = level.f_46441_.m_188500_() * 0.2;
        double motionZ = level.f_46441_.m_188500_() * 0.2 - 0.1;
        this.m_20334_(motionX, motionY, motionZ);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(GLASS_TYPE, (Object)0);
        this.f_19804_.m_135372_(LIFETIME, (Object)ModConfig.glassShardLifetime);
        this.f_19804_.m_135372_(ON_GROUND_SHARD, (Object)false);
    }

    public void m_8119_() {
        int currentLifetime;
        boolean isOnGround;
        super.m_8119_();
        Vec3 movement = this.m_20184_();
        double frictionFactor = ModConfig.glassShardFriction;
        this.m_20334_(movement.f_82479_ * (1.0 - frictionFactor * 0.2), movement.f_82480_ - 0.04, movement.f_82481_ * (1.0 - frictionFactor * 0.2));
        if (!((Boolean)this.f_19804_.m_135370_(ON_GROUND_SHARD)).booleanValue() && movement.m_82556_() > 0.01) {
            this.checkForEntityCollisions();
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        BlockPos blockPos = this.m_20183_();
        BlockState blockState = this.m_9236_().m_8055_(blockPos);
        boolean bl = isOnGround = !blockState.m_60795_() && this.f_19863_;
        if (isOnGround) {
            double groundFriction = frictionFactor * 1.5;
            this.m_20334_(movement.f_82479_ * (1.0 - groundFriction), -movement.f_82480_ * 0.2, movement.f_82481_ * (1.0 - groundFriction));
            if (Math.abs(movement.f_82480_) > 0.2 && !this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 0.1f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.8f);
                this.m_20225_(true);
            }
            if (!((Boolean)this.f_19804_.m_135370_(ON_GROUND_SHARD)).booleanValue()) {
                this.f_19804_.m_135381_(ON_GROUND_SHARD, (Object)true);
                this.setLifetime(ModConfig.glassShardGroundTime);
            }
            ++this.groundTime;
            if (!this.settled && Math.abs(movement.f_82479_) < 0.01 && Math.abs(movement.f_82481_) < 0.01) {
                this.settled = true;
                System.out.println("Glass shard settled on ground");
            }
        }
        if ((currentLifetime = this.getLifetime()) <= 0) {
            this.m_146870_();
        } else {
            this.setLifetime(currentLifetime - 1);
        }
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("GlassType")) {
            this.setGlassType(tag.m_128451_("GlassType"));
        }
        if (tag.m_128441_("Lifetime")) {
            this.setLifetime(tag.m_128451_("Lifetime"));
        }
        if (tag.m_128441_("OnGroundShard")) {
            this.f_19804_.m_135381_(ON_GROUND_SHARD, (Object)tag.m_128471_("OnGroundShard"));
        }
        if (tag.m_128441_("GroundTime")) {
            this.groundTime = tag.m_128451_("GroundTime");
        }
        if (tag.m_128441_("Settled")) {
            this.settled = tag.m_128471_("Settled");
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("GlassType", this.getGlassType());
        tag.m_128405_("Lifetime", this.getLifetime());
        tag.m_128379_("OnGroundShard", ((Boolean)this.f_19804_.m_135370_(ON_GROUND_SHARD)).booleanValue());
        tag.m_128405_("GroundTime", this.groundTime);
        tag.m_128379_("Settled", this.settled);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public int getGlassType() {
        return (Integer)this.f_19804_.m_135370_(GLASS_TYPE);
    }

    public void setGlassType(int glassType) {
        this.f_19804_.m_135381_(GLASS_TYPE, (Object)glassType);
    }

    public int getLifetime() {
        return (Integer)this.f_19804_.m_135370_(LIFETIME);
    }

    public void setLifetime(int lifetime) {
        this.f_19804_.m_135381_(LIFETIME, (Object)lifetime);
    }

    public Block getSourceBlock() {
        return this.sourceBlock;
    }

    public boolean isOnGround() {
        return (Boolean)this.f_19804_.m_135370_(ON_GROUND_SHARD) != false && this.settled;
    }

    private void checkForEntityCollisions() {
        Vec3 velocity;
        double speed;
        if (!this.m_9236_().m_5776_() && (speed = (velocity = this.m_20184_()).m_82553_()) > 0.1) {
            Vec3 direction = velocity.m_82541_();
            double lookAhead = 0.3;
            AABB collisionBox = this.m_20191_().m_82363_(direction.f_82479_ * lookAhead, direction.f_82480_ * lookAhead, direction.f_82481_ * lookAhead);
            List entities = this.m_9236_().m_45976_(LivingEntity.class, collisionBox);
            for (LivingEntity entity : entities) {
                Player player;
                if (entity instanceof Player && (player = (Player)entity).m_7500_() || entity.equals((Object)this.getOwner())) continue;
                float damage = (float)Math.min(speed * 5.0, 1.0);
                boolean damaged = entity.m_6469_(ModDamageSources.glassShardDamage(this.m_9236_(), this, this.getOwner()), damage);
                if (!damaged) continue;
                this.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12323_, SoundSource.PLAYERS, 0.5f, 1.0f);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 0.8f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                this.m_146870_();
                break;
            }
        }
    }

    public Entity getOwner() {
        return null;
    }

    private int getGlassTypeId(Block block) {
        if (block == Blocks.f_50058_) {
            return 0;
        }
        if (block == Blocks.f_50147_) {
            return 1;
        }
        if (block == Blocks.f_50148_) {
            return 2;
        }
        if (block == Blocks.f_50202_) {
            return 3;
        }
        if (block == Blocks.f_50203_) {
            return 4;
        }
        if (block == Blocks.f_50204_) {
            return 5;
        }
        if (block == Blocks.f_50205_) {
            return 6;
        }
        if (block == Blocks.f_50206_) {
            return 7;
        }
        if (block == Blocks.f_50207_) {
            return 8;
        }
        if (block == Blocks.f_50208_) {
            return 9;
        }
        if (block == Blocks.f_50209_) {
            return 10;
        }
        if (block == Blocks.f_50210_) {
            return 11;
        }
        if (block == Blocks.f_50211_) {
            return 12;
        }
        if (block == Blocks.f_50212_) {
            return 13;
        }
        if (block == Blocks.f_50213_) {
            return 14;
        }
        if (block == Blocks.f_50214_) {
            return 15;
        }
        if (block == Blocks.f_50215_) {
            return 16;
        }
        if (block == Blocks.f_152498_) {
            return 17;
        }
        if (block == Blocks.f_50185_) {
            return 100;
        }
        if (block == Blocks.f_50303_) {
            return 101;
        }
        if (block == Blocks.f_50304_) {
            return 102;
        }
        if (block == Blocks.f_50305_) {
            return 103;
        }
        if (block == Blocks.f_50306_) {
            return 104;
        }
        if (block == Blocks.f_50307_) {
            return 105;
        }
        if (block == Blocks.f_50361_) {
            return 106;
        }
        if (block == Blocks.f_50362_) {
            return 107;
        }
        if (block == Blocks.f_50363_) {
            return 108;
        }
        if (block == Blocks.f_50364_) {
            return 109;
        }
        if (block == Blocks.f_50365_) {
            return 110;
        }
        if (block == Blocks.f_50366_) {
            return 111;
        }
        if (block == Blocks.f_50367_) {
            return 112;
        }
        if (block == Blocks.f_50368_) {
            return 113;
        }
        if (block == Blocks.f_50369_) {
            return 114;
        }
        if (block == Blocks.f_50370_) {
            return 115;
        }
        if (block == Blocks.f_50371_) {
            return 116;
        }
        return 0;
    }
}

