/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosbetterglassmod.listener;

import de.sarocesch.sarosbetterglassmod.config.ModConfig;
import de.sarocesch.sarosbetterglassmod.entity.GlassShardEntity;
import de.sarocesch.sarosbetterglassmod.util.GlassUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sarosbetterglassmod")
public class AnvilListener {
    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (!ModConfig.enableAnvilGlassBreaking) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && (level = event.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AABB worldBounds = new AABB((double)serverLevel.m_141937_(), (double)serverLevel.m_141937_(), (double)serverLevel.m_141937_(), (double)serverLevel.m_151558_(), (double)serverLevel.m_151558_(), (double)serverLevel.m_151558_());
            List fallingBlockEntities = serverLevel.m_6443_(FallingBlockEntity.class, worldBounds, entity -> entity.m_31980_().m_60713_(Blocks.f_50322_) || entity.m_31980_().m_60713_(Blocks.f_50323_) || entity.m_31980_().m_60713_(Blocks.f_50324_));
            for (FallingBlockEntity fallingBlockEntity : fallingBlockEntities) {
                BlockPos posBelow = fallingBlockEntity.m_20183_().m_7495_();
                BlockState stateBelow = serverLevel.m_8055_(posBelow);
                if (!GlassUtil.isGlassBlock(stateBelow.m_60734_())) continue;
                AnvilListener.spawnGlassShards((Level)serverLevel, posBelow, stateBelow.m_60734_());
                serverLevel.m_46961_(posBelow, false);
            }
        }
    }

    private static void spawnGlassShards(Level level, BlockPos pos, Block glassBlock) {
        if (!ModConfig.enableGlassShards) {
            return;
        }
        int count = (int)((double)ModConfig.glassShardCount * 1.3);
        int randomVariation = Math.max(1, count / 5);
        count = count - randomVariation + level.f_46441_.m_188503_(randomVariation * 2 + 1);
        for (int i = 0; i < count; ++i) {
            double dz;
            double dy;
            double spreadFactor = 1.0;
            double x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * spreadFactor;
            double y = (double)pos.m_123342_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * spreadFactor;
            double z = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * spreadFactor;
            GlassShardEntity shard = new GlassShardEntity(level, x, y, z, glassBlock);
            double dx = x - ((double)pos.m_123341_() + 0.5);
            double length = Math.sqrt(dx * dx + (dy = y - ((double)pos.m_123342_() + 0.5)) * dy + (dz = z - ((double)pos.m_123343_() + 0.5)) * dz);
            if (length > 0.0) {
                double scaleFactor = 0.25 + level.f_46441_.m_188500_() * 0.25;
                dx = dx / length * scaleFactor;
                dy = dy / length * scaleFactor;
                dz = dz / length * scaleFactor;
            } else {
                dx = (level.f_46441_.m_188500_() - 0.5) * 0.4;
                dy = level.f_46441_.m_188500_() * 0.2 - 0.1;
                dz = (level.f_46441_.m_188500_() - 0.5) * 0.4;
            }
            shard.m_20334_(dx, dy -= 0.05 + level.f_46441_.m_188500_() * 0.1, dz);
            level.m_7967_((Entity)shard);
        }
    }
}

