/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosbetterglassmod.listener;

import de.sarocesch.sarosbetterglassmod.config.ModConfig;
import de.sarocesch.sarosbetterglassmod.entity.GlassShardEntity;
import de.sarocesch.sarosbetterglassmod.util.GlassUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod.EventBusSubscriber(modid="sarosbetterglassmod", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ArrowListener {
    public ArrowListener() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        BlockPos blockPos;
        if (!ModConfig.enableArrowGlassBreaking) {
            return;
        }
        if (!(event.getProjectile() instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)event.getProjectile();
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        Level world = arrow.m_9236_();
        BlockState blockState = world.m_8055_(blockPos = ((BlockHitResult)hitResult).m_82425_());
        Block block = blockState.m_60734_();
        if (GlassUtil.isGlassBlock(block)) {
            this.spawnGlassShards(world, blockPos, block);
            world.m_46961_(blockPos, false);
            CompoundTag arrowData = new CompoundTag();
            arrow.m_20223_(arrowData);
            arrow.m_142687_(Entity.RemovalReason.DISCARDED);
            Arrow newArrow = new Arrow(world, arrow.m_20185_(), arrow.m_20186_(), arrow.m_20189_());
            newArrow.m_20258_(arrowData);
            newArrow.f_36705_ = arrow.f_36705_;
            world.m_7967_((Entity)newArrow);
        }
    }

    private void spawnGlassShards(Level level, BlockPos pos, Block glassBlock) {
        if (!ModConfig.enableGlassShards) {
            return;
        }
        int count = ModConfig.glassShardCount;
        int randomVariation = Math.max(1, count / 5);
        count = count - randomVariation + level.f_46441_.m_188503_(randomVariation * 2 + 1);
        for (int i = 0; i < count; ++i) {
            double dz;
            double dy;
            double spreadFactor = 0.8;
            double x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * spreadFactor;
            double y = (double)pos.m_123342_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * spreadFactor;
            double z = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * spreadFactor;
            GlassShardEntity shard = new GlassShardEntity(level, x, y, z, glassBlock);
            double dx = x - ((double)pos.m_123341_() + 0.5);
            double length = Math.sqrt(dx * dx + (dy = y - ((double)pos.m_123342_() + 0.5)) * dy + (dz = z - ((double)pos.m_123343_() + 0.5)) * dz);
            if (length > 0.0) {
                double scaleFactor = 0.15 + level.f_46441_.m_188500_() * 0.2;
                dx = dx / length * scaleFactor;
                dy = dy / length * scaleFactor;
                dz = dz / length * scaleFactor;
            } else {
                dx = (level.f_46441_.m_188500_() - 0.5) * 0.25;
                dy = level.f_46441_.m_188500_() * 0.25;
                dz = (level.f_46441_.m_188500_() - 0.5) * 0.25;
            }
            shard.m_20334_(dx, dy += 0.05 + level.f_46441_.m_188500_() * 0.1, dz);
            level.m_7967_((Entity)shard);
        }
    }

    @Mod.EventBusSubscriber(modid="sarosbetterglassmod", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventSubscriber {
        @SubscribeEvent
        public static void onModConstruct(FMLConstructModEvent event) {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                new ArrowListener();
            }
        }

        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

