/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosbetterglassmod.listener;

import com.mojang.logging.LogUtils;
import de.sarocesch.sarosbetterglassmod.config.ModConfig;
import de.sarocesch.sarosbetterglassmod.entity.GlassShardEntity;
import de.sarocesch.sarosbetterglassmod.util.GlassUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="sarosbetterglassmod")
public class EntityGlassBreakListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<UUID, Vec3> previousVelocities = new HashMap<UUID, Vec3>();
    private static final Map<UUID, Long> lastGlassBreakTimes = new HashMap<UUID, Long>();
    private static final long GLASS_BREAK_COOLDOWN = 1000L;

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        double sizeFactor;
        double potentialDamage;
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        if (!ModConfig.enableEntityGlassBreaking) {
            return;
        }
        Vec3 velocity = entity.m_20184_();
        double speed = velocity.m_82553_();
        double speedThreshold = 0.1;
        if ((double)entity.m_20205_() > 1.0 || (double)entity.m_20206_() > 2.0) {
            speedThreshold = 0.05;
        }
        if (speed < speedThreshold) {
            previousVelocities.put(entity.m_20148_(), velocity);
            return;
        }
        UUID entityId = entity.m_20148_();
        long currentTime = System.currentTimeMillis();
        Long lastBreakTime = lastGlassBreakTimes.get(entityId);
        if (lastBreakTime != null && currentTime - lastBreakTime < 1000L) {
            previousVelocities.put(entityId, velocity);
            return;
        }
        Vec3 prevVelocity = previousVelocities.getOrDefault(entityId, Vec3.f_82478_);
        Vec3 velocityChange = prevVelocity.m_82546_(velocity);
        double deceleration = velocityChange.m_82553_();
        previousVelocities.put(entityId, velocity);
        double decelerationThreshold = 0.05;
        if ((double)entity.m_20205_() > 1.0 || (double)entity.m_20206_() > 2.0) {
            decelerationThreshold = 0.03;
        }
        if (deceleration > decelerationThreshold && (potentialDamage = speed * deceleration * 10.0 * Math.max(1.0, sizeFactor = (double)(entity.m_20205_() * entity.m_20206_()) / 2.0)) >= ModConfig.entityGlassBreakingThreshold && EntityGlassBreakListener.checkAndBreakGlass(entity, level, velocity)) {
            lastGlassBreakTimes.put(entityId, currentTime);
            if (entity instanceof Player) {
                LOGGER.info("Player broke through glass! Potential damage: {} hearts", (Object)potentialDamage);
            } else {
                LOGGER.debug("Entity {} broke through glass! Potential damage: {} hearts", (Object)entity.m_6095_().m_20675_(), (Object)potentialDamage);
            }
        }
        if (level.m_46467_() % 200L == 0L) {
            long expiryTime = currentTime - 60000L;
            previousVelocities.entrySet().removeIf(entry -> lastGlassBreakTimes.getOrDefault(entry.getKey(), 0L) < expiryTime);
            lastGlassBreakTimes.entrySet().removeIf(entry -> (Long)entry.getValue() < expiryTime);
        }
    }

    private static boolean checkAndBreakGlass(LivingEntity entity, Level level, Vec3 velocity) {
        Vec3 direction = velocity.m_82541_();
        AABB entityBox = entity.m_20191_();
        double width = entityBox.m_82362_();
        double height = entityBox.m_82376_();
        double speedFactor = Math.min(2.0, velocity.m_82553_() * 5.0);
        double lookAhead = Math.max(width, 0.5) * speedFactor;
        AABB checkBox = entityBox.m_82400_(0.2).m_82386_(direction.f_82479_ * lookAhead, direction.f_82480_ * lookAhead, direction.f_82481_ * lookAhead);
        for (int x = (int)Math.floor(checkBox.f_82288_); x <= (int)Math.floor(checkBox.f_82291_); ++x) {
            for (int y = (int)Math.floor(checkBox.f_82289_); y <= (int)Math.floor(checkBox.f_82292_); ++y) {
                for (int z = (int)Math.floor(checkBox.f_82290_); z <= (int)Math.floor(checkBox.f_82293_); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    Block block = state.m_60734_();
                    if (!GlassUtil.isGlassBlock(block)) continue;
                    LOGGER.debug("Entity {} is breaking glass at {}", (Object)entity.m_6095_().m_20675_(), (Object)pos);
                    level.m_46961_(pos, false);
                    EntityGlassBreakListener.createGlassParticles(level, pos, state);
                    if (ModConfig.enableGlassShards) {
                        EntityGlassBreakListener.spawnGlassShards(level, pos, block, direction);
                    }
                    level.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
            }
        }
        return false;
    }

    private static void createGlassParticles(Level level, BlockPos pos, BlockState state) {
        if (level.m_5776_()) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockParticleOption particleOptions = new BlockParticleOption(ParticleTypes.f_123794_, state);
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            for (int i = 0; i < 50; ++i) {
                double offsetX = level.f_46441_.m_188583_() * 0.2;
                double offsetY = level.f_46441_.m_188583_() * 0.2;
                double offsetZ = level.f_46441_.m_188583_() * 0.2;
                serverLevel.m_8767_((ParticleOptions)particleOptions, x, y, z, 1, offsetX, offsetY, offsetZ, 0.05);
            }
        }
    }

    private static void spawnGlassShards(Level level, BlockPos pos, Block block, Vec3 direction) {
        if (level.m_5776_()) {
            return;
        }
        int count = level.f_46441_.m_188503_(4) + 3;
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.5;
            double y = (double)pos.m_123342_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.5;
            double z = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.5;
            GlassShardEntity shard = new GlassShardEntity(level, x, y, z, block);
            double vx = direction.f_82479_ * 0.2 + (level.f_46441_.m_188500_() - 0.5) * 0.1;
            double vy = direction.f_82480_ * 0.2 + (level.f_46441_.m_188500_() - 0.5) * 0.1;
            double vz = direction.f_82481_ * 0.2 + (level.f_46441_.m_188500_() - 0.5) * 0.1;
            shard.m_20334_(vx, vy, vz);
            level.m_7967_((Entity)shard);
        }
    }
}

