/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosbetterglassmod.listener;

import de.sarocesch.sarosbetterglassmod.config.ModConfig;
import de.sarocesch.sarosbetterglassmod.entity.GlassShardEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sarosbetterglassmod")
public class EntityStepListener {
    private static final Map<UUID, Long> lastDamageTimes = new HashMap<UUID, Long>();
    private static final long DAMAGE_COOLDOWN = 500L;
    private static final Block[] GLASS_BLOCKS = new Block[]{Blocks.f_50016_};

    @SubscribeEvent
    public static void onEntityStep(LivingEvent.LivingTickEvent event) {
        boolean damaged;
        boolean hasGlassShardsNearby;
        Player player;
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        if (!ModConfig.enableGlassShardDamage) {
            return;
        }
        if (!entity.m_20096_()) {
            return;
        }
        if (ModConfig.shoesProtectFromGlass && EntityStepListener.hasBootsEquipped(entity)) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return;
        }
        UUID entityId = entity.m_20148_();
        long currentTime = System.currentTimeMillis();
        Long lastDamageTime = lastDamageTimes.get(entityId);
        if (lastDamageTime != null && currentTime - lastDamageTime < 500L) {
            return;
        }
        BlockPos pos = entity.m_20183_().m_7495_();
        if (entity.m_20096_() && entity.m_6084_() && (hasGlassShardsNearby = EntityStepListener.checkForGlassShardsNearby((Entity)entity)) && (damaged = entity.m_6469_(level.m_269111_().m_269325_(), (float)ModConfig.glassShardDamageAmount))) {
            lastDamageTimes.put(entityId, currentTime);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12323_, SoundSource.PLAYERS, 0.5f, 1.0f);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11987_, SoundSource.BLOCKS, 0.8f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            if (entity instanceof Player) {
                System.out.println("Player took glass shard damage from direct approach!");
            }
        }
    }

    private static boolean checkForGlassShardsNearby(Entity entity) {
        AABB searchBox;
        Level level = entity.m_9236_();
        List shards = level.m_6443_(GlassShardEntity.class, searchBox = new AABB(entity.m_20185_() - 0.5, entity.m_20186_() - 0.1, entity.m_20189_() - 0.5, entity.m_20185_() + 0.5, entity.m_20186_() + 0.1, entity.m_20189_() + 0.5), shard -> shard.isOnGround());
        if (!shards.isEmpty() && entity instanceof Player) {
            System.out.println("Found " + shards.size() + " glass shards near player!");
        }
        return !shards.isEmpty();
    }

    private static boolean hasBootsEquipped(LivingEntity entity) {
        ItemStack boots = entity.m_6844_(EquipmentSlot.FEET);
        return !boots.m_41619_();
    }
}

