/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosbetterglassmod.listener;

import de.sarocesch.sarosbetterglassmod.config.ModConfig;
import de.sarocesch.sarosbetterglassmod.entity.GlassShardEntity;
import de.sarocesch.sarosbetterglassmod.util.GlassUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="sarosbetterglassmod")
public class GlassBreakListener {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockState state = event.getState();
        Block block = state.m_60734_();
        if (GlassUtil.isGlassBlock(block)) {
            BlockPos pos = event.getPos();
            Level level = event.getPlayer().m_9236_();
            GlassBreakListener.createGlassParticles(level, pos, state);
            if (ModConfig.enableMiningGlassShards && ModConfig.enableGlassShards) {
                GlassBreakListener.spawnGlassShards(level, pos, block);
            }
        }
    }

    public static void handleGlassBreak(Level level, BlockPos pos, BlockState state, @Nullable Entity shooter) {
        if (level.m_5776_()) {
            return;
        }
        Block block = state.m_60734_();
        if (!GlassUtil.isGlassBlock(block)) {
            return;
        }
        GlassBreakListener.createGlassParticles(level, pos, state);
        if (ModConfig.enableGlassShards) {
            GlassBreakListener.spawnGlassShards(level, pos, block);
        }
        level.m_46953_(pos, false, shooter);
    }

    public static boolean isBreakableGlass(BlockState state) {
        return state.m_60734_() instanceof GlassBlock || state.m_60734_() instanceof StainedGlassBlock;
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        Level level = event.getLevel();
        for (BlockPos pos : explosion.m_46081_()) {
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (!GlassUtil.isGlassBlock(block)) continue;
            GlassBreakListener.createGlassParticles(level, pos, state);
            if (!ModConfig.enableExplosionGlassShards || !ModConfig.enableGlassShards) continue;
            GlassBreakListener.spawnGlassShards(level, pos, block);
        }
    }

    public static void createGlassParticles(Level level, BlockPos pos, BlockState state) {
        if (level.m_5776_()) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockParticleOption particleOptions = new BlockParticleOption(ParticleTypes.f_123794_, state);
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            for (int i = 0; i < 50; ++i) {
                double offsetX = level.f_46441_.m_188583_() * 0.2;
                double offsetY = level.f_46441_.m_188583_() * 0.2;
                double offsetZ = level.f_46441_.m_188583_() * 0.2;
                serverLevel.m_8767_((ParticleOptions)particleOptions, x, y, z, 1, offsetX, offsetY, offsetZ, 0.05);
            }
        }
    }

    public static void spawnGlassShards(Level level, BlockPos pos, Block block) {
        if (level.m_5776_()) {
            return;
        }
        int count = level.f_46441_.m_188503_(4) + 3;
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.5;
            double y = (double)pos.m_123342_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.5;
            double z = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.5;
            GlassShardEntity shard = new GlassShardEntity(level, x, y, z, block);
            double vx = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            double vy = level.f_46441_.m_188500_() * 0.2;
            double vz = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            shard.m_20334_(vx, vy, vz);
            level.m_7967_((Entity)shard);
        }
    }
}

