/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.module.chirper.command.executor;

import java.util.List;
import java.util.Optional;
import me.whereareiam.socialismus.api.Serializer;
import me.whereareiam.socialismus.api.model.CommandEntity;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.model.serializer.SerializerContent;
import me.whereareiam.socialismus.api.model.serializer.SerializerPlaceholder;
import me.whereareiam.socialismus.api.output.command.CommandBase;
import me.whereareiam.socialismus.api.output.command.CommandCooldown;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.module.chirper.api.input.AnnouncementBroadcaster;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.Announcement;
import me.whereareiam.socialismus.module.chirper.api.model.config.ChirperCommands;
import me.whereareiam.socialismus.module.chirper.api.model.config.ChirperMessages;
import org.incendo.cloud.annotations.Argument;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.CommandDescription;
import org.incendo.cloud.annotations.Permission;

@Singleton
public class AnnounceCommand
extends CommandBase {
    private static final String COMMAND_NAME = "announce";
    private final AnnouncementBroadcaster broadcaster;
    private final Provider<ChirperCommands> commands;
    private final Provider<ChirperMessages> messages;
    private final Provider<List<Announcement>> announcements;

    @Inject
    public AnnounceCommand(AnnouncementBroadcaster broadcaster, Provider<ChirperCommands> commands, Provider<ChirperMessages> messages, Provider<List<Announcement>> announcements) {
        super(COMMAND_NAME);
        this.broadcaster = broadcaster;
        this.commands = commands;
        this.messages = messages;
        this.announcements = announcements;
    }

    @Command(value="%command.announce")
    @CommandDescription(value="%description.announce")
    @CommandCooldown(value="%cooldown.announce")
    @Permission(value={"%permission.announce"})
    public void onCommand(DummyPlayer dummyPlayer, @Argument(value="id") String id, @Argument(value="bool") boolean simplified) {
        Optional<Announcement> announcement = ((List)this.announcements.get()).stream().filter(a -> a.getId().equals(id)).findFirst();
        if (announcement.isEmpty()) {
            dummyPlayer.getAudience().sendMessage(Serializer.serialize((SerializerContent)new SerializerContent(dummyPlayer, List.of(new SerializerPlaceholder("{id}", id)), ((ChirperMessages)this.messages.get()).getNoAnnouncementFound())));
            return;
        }
        dummyPlayer.getAudience().sendMessage(Serializer.serialize((SerializerContent)new SerializerContent(dummyPlayer, List.of(new SerializerPlaceholder("{id}", id)), ((ChirperMessages)this.messages.get()).getAnnouncementBroadcasted())));
        this.broadcaster.broadcast(announcement.get(), simplified);
    }

    public CommandEntity getCommandEntity() {
        return ((ChirperCommands)this.commands.get()).getCommands().get(COMMAND_NAME);
    }
}

