/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.module.chirper.common;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.Reloadable;
import me.whereareiam.socialismus.api.input.registry.Registry;
import me.whereareiam.socialismus.api.model.scheduler.PeriodicalRunnableTask;
import me.whereareiam.socialismus.api.output.PlatformInteractor;
import me.whereareiam.socialismus.api.output.Scheduler;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.module.chirper.api.input.AnnouncementBroadcaster;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.Announcement;
import me.whereareiam.socialismus.module.chirper.api.model.announcer.Announcer;
import me.whereareiam.socialismus.module.chirper.api.model.announcer.InternalAnnouncer;

@Singleton
public class AnnouncerController
implements Reloadable {
    private final Scheduler scheduler;
    private final Provider<List<Announcer>> announcerProvider;
    private final Provider<List<Announcement>> announcementProvider;
    private final AnnouncementBroadcaster broadcaster;
    private final PlatformInteractor interactor;
    private final Map<InternalAnnouncer, List<Announcement>> announcers = new HashMap<InternalAnnouncer, List<Announcement>>();

    @Inject
    public AnnouncerController(Registry<Reloadable> reloadableRegistry, Scheduler scheduler, Provider<List<Announcer>> announcerProvider, Provider<List<Announcement>> announcementProvider, AnnouncementBroadcaster broadcaster, PlatformInteractor interactor) {
        this.scheduler = scheduler;
        this.announcerProvider = announcerProvider;
        this.announcementProvider = announcementProvider;
        this.broadcaster = broadcaster;
        this.interactor = interactor;
        reloadableRegistry.register((Object)this);
    }

    public void init() {
        List announcersList = (List)this.announcerProvider.get();
        List announcementsList = (List)this.announcementProvider.get();
        Logger.debug((String)("Loaded " + announcersList.size() + " announcers and " + announcementsList.size() + " announcements"), (Object[])new Object[0]);
        for (Announcer announcer : announcersList) {
            if (announcer.getAnnouncements().isEmpty()) continue;
            List filteredAnnouncements = announcementsList.stream().filter(announcement -> announcer.getAnnouncements().contains(announcement.getId())).collect(Collectors.toList());
            switch (announcer.getSettings().getOrder()) {
                case DESCENDING: {
                    filteredAnnouncements.sort(Comparator.comparing(Announcement::getId));
                    break;
                }
                case ASCENDING: {
                    filteredAnnouncements.sort(Comparator.comparing(Announcement::getId).reversed());
                    break;
                }
                case RANDOM: {
                    Collections.shuffle(filteredAnnouncements);
                }
            }
            this.announcers.put((InternalAnnouncer)((InternalAnnouncer.InternalAnnouncerBuilder)((InternalAnnouncer.InternalAnnouncerBuilder)((InternalAnnouncer.InternalAnnouncerBuilder)((Announcer.AnnouncerBuilder)InternalAnnouncer.builder().index(0)).enabled(announcer.isEnabled())).announcements(announcer.getAnnouncements())).settings(announcer.getSettings())).build(), filteredAnnouncements);
            this.runAnnouncers();
        }
    }

    private void runAnnouncers() {
        Random random = new Random();
        this.announcers.forEach((announcer, announcements) -> {
            long delay = (long)announcer.getSettings().getDelay() * 1000L;
            long interval = (long)announcer.getSettings().getInterval() * 1000L;
            int taskId = random.nextInt();
            Logger.debug((String)("Scheduling task #" + taskId + " for announcer with delay=" + delay + "ms, interval=" + interval + "ms"), (Object[])new Object[0]);
            this.scheduler.schedule(((PeriodicalRunnableTask.PeriodicalRunnableTaskBuilder)((PeriodicalRunnableTask.PeriodicalRunnableTaskBuilder)((PeriodicalRunnableTask.PeriodicalRunnableTaskBuilder)PeriodicalRunnableTask.builder().id(taskId)).module("chirper")).runnable(() -> this.broadcastNextAnnouncement((InternalAnnouncer)announcer))).delay(delay).period(interval).build(), true);
        });
    }

    private void broadcastNextAnnouncement(InternalAnnouncer announcer) {
        Announcement nextAnnouncement = this.getNextAnnouncement(announcer);
        if (nextAnnouncement != null && announcer.getSettings().getMinPlayers() <= this.interactor.getOnlinePlayersCount()) {
            if (!nextAnnouncement.getSettings().isRepeat()) {
                this.announcers.get(announcer).remove(nextAnnouncement);
            }
            this.broadcaster.broadcast(nextAnnouncement);
        }
    }

    private Announcement getNextAnnouncement(InternalAnnouncer announcer) {
        List<Announcement> announcements = this.announcers.get(announcer);
        if (announcements == null || announcements.isEmpty()) {
            return null;
        }
        int currentIndex = announcer.getIndex();
        Announcement nextAnnouncement = announcements.get(currentIndex);
        announcer.setIndex((currentIndex + 1) % announcements.size());
        return nextAnnouncement;
    }

    public void reload() {
        this.announcers.clear();
        this.scheduler.cancelByModule("chirper");
        this.init();
    }
}

