/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.module.chirper.common.broadcast;

import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import me.whereareiam.socialismus.api.input.container.PlayerContainerService;
import me.whereareiam.socialismus.api.input.requirement.RequirementEvaluatorService;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.model.scheduler.DelayedRunnableTask;
import me.whereareiam.socialismus.api.output.Scheduler;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.module.chirper.api.input.AnnouncementBroadcaster;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.Announcement;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.AnnouncementContent;
import me.whereareiam.socialismus.module.chirper.api.type.AnnouncementType;
import me.whereareiam.socialismus.module.chirper.common.broadcast.BroadcastSender;

@Singleton
public class BroadcastCoordinator
implements AnnouncementBroadcaster {
    private final Scheduler scheduler;
    private final PlayerContainerService playerContainer;
    private final BroadcastSender broadcastSender;
    private final RequirementEvaluatorService requirementEvaluator;

    @Inject
    public BroadcastCoordinator(Scheduler scheduler, PlayerContainerService playerContainer, BroadcastSender broadcastSender, RequirementEvaluatorService requirementEvaluator) {
        this.scheduler = scheduler;
        this.playerContainer = playerContainer;
        this.broadcastSender = broadcastSender;
        this.requirementEvaluator = requirementEvaluator;
    }

    @Override
    public void broadcast(Announcement announcement) {
        Random random = new Random();
        Set<DummyPlayer> recipients = this.playerContainer.getPlayers();
        recipients = recipients.parallelStream().filter(r -> this.requirementEvaluator.check(announcement.getRequirements(), r)).collect(Collectors.toSet());
        if (announcement.getSettings().getDelay() > 0) {
            Set<DummyPlayer> finalRecipients = recipients;
            this.scheduler.schedule(((DelayedRunnableTask.DelayedRunnableTaskBuilder)((DelayedRunnableTask.DelayedRunnableTaskBuilder)((DelayedRunnableTask.DelayedRunnableTaskBuilder)DelayedRunnableTask.builder().id(random.nextInt())).module("chirper")).delay((long)announcement.getSettings().getDelay() * 1000L).runnable(() -> this.sendAnnouncement(announcement, finalRecipients))).build());
            return;
        }
        this.sendAnnouncement(announcement, recipients);
    }

    @Override
    public void broadcast(Announcement announcement, boolean simplified) {
        if (!simplified) {
            this.broadcast(announcement);
            return;
        }
        Set recipients = this.playerContainer.getPlayers();
        this.sendAnnouncement(announcement, recipients);
    }

    private void sendAnnouncement(Announcement announcement, Set<DummyPlayer> recipients) {
        for (DummyPlayer recipient : recipients) {
            for (Map.Entry<AnnouncementType, ? extends AnnouncementContent> entry : announcement.getContents().entrySet()) {
                if (!this.requirementEvaluator.check(entry.getValue().getRequirements(), recipient)) continue;
                this.broadcastSender.sendContent(entry.getKey(), entry.getValue(), recipient);
            }
        }
    }
}

