/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.module.chirper.common.broadcast;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import me.whereareiam.socialismus.api.Serializer;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.AnnouncementContent;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.variant.ActionbarAnnouncement;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.variant.BossBarAnnouncement;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.variant.MessageAnnouncement;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.variant.SoundAnnouncement;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.variant.TitleAnnouncement;
import me.whereareiam.socialismus.module.chirper.api.type.AnnouncementType;
import me.whereareiam.socialismus.module.chirper.common.util.BossBarUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;

@Singleton
public class BroadcastSender {
    private final BossBarUtil bossBarUtil;

    public void sendContent(AnnouncementType type, AnnouncementContent content, DummyPlayer recipient) {
        Audience audience = recipient.getAudience();
        switch (type) {
            case MESSAGE: {
                audience.sendMessage(Serializer.serialize((DummyPlayer)recipient, (String)String.join((CharSequence)"\n", ((MessageAnnouncement)content).getMessage())));
                break;
            }
            case BOSSBAR: {
                this.bossBarUtil.createTemporaryBossBar(recipient, BossBar.bossBar((Component)Serializer.serialize((DummyPlayer)recipient, (String)((BossBarAnnouncement)content).getMessage()), (float)1.0f, (BossBar.Color)((BossBarAnnouncement)content).getColor(), (BossBar.Overlay)((BossBarAnnouncement)content).getOverlay()), ((BossBarAnnouncement)content).getSettings().getDuration());
                break;
            }
            case TITLE: {
                TitleAnnouncement title = (TitleAnnouncement)content;
                audience.showTitle(Title.title((Component)Serializer.serialize((DummyPlayer)recipient, (String)title.getTitle()), (Component)Serializer.serialize((DummyPlayer)recipient, (String)title.getSubtitle()), (Title.Times)Title.Times.times((Duration)Duration.of(title.getSettings().getFadeIn(), ChronoUnit.MILLIS), (Duration)Duration.of(title.getSettings().getStay(), ChronoUnit.MILLIS), (Duration)Duration.of(title.getSettings().getFadeOut(), ChronoUnit.MILLIS))));
                break;
            }
            case ACTIONBAR: {
                audience.sendActionBar(Serializer.serialize((DummyPlayer)recipient, (String)((ActionbarAnnouncement)content).getMessage()));
                break;
            }
            case SOUND: {
                SoundAnnouncement sound = (SoundAnnouncement)content;
                audience.playSound(Sound.sound((Key)Key.key((String)sound.getSound()), (Sound.Source)Sound.Source.MASTER, (float)sound.getSettings().getVolume(), (float)sound.getSettings().getPitch()));
            }
        }
    }

    @Inject
    @Generated
    public BroadcastSender(BossBarUtil bossBarUtil) {
        this.bossBarUtil = bossBarUtil;
    }
}

