/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.module.chirper.common.util;

import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.model.scheduler.DelayedRunnableTask;
import me.whereareiam.socialismus.api.output.Scheduler;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;

@Singleton
public class BossBarUtil {
    private final Scheduler scheduler;

    @Inject
    public BossBarUtil(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void createTemporaryBossBar(DummyPlayer dummyPlayer, BossBar bossBar, int duration) {
        Audience audience = dummyPlayer.getAudience();
        audience.showBossBar(bossBar);
        double damagePerSecond = 1.0 / (double)duration;
        for (int i = 1; i <= duration; ++i) {
            DelayedRunnableTask task = ((DelayedRunnableTask.DelayedRunnableTaskBuilder)DelayedRunnableTask.builder().delay((long)i * 1000L).runnable(() -> {
                if (bossBar.progress() > 0.0f) {
                    bossBar.progress(Math.max(0.0f, bossBar.progress() - (float)damagePerSecond));
                }
            })).build();
            this.scheduler.schedule(task);
        }
        DelayedRunnableTask hideTask = ((DelayedRunnableTask.DelayedRunnableTaskBuilder)DelayedRunnableTask.builder().delay((long)duration * 1000L).runnable(() -> audience.hideBossBar(bossBar))).build();
        this.scheduler.schedule(hideTask);
    }
}

