/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.module.chirper.configuration;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import me.whereareiam.socialismus.library.guice.AbstractModule;
import me.whereareiam.socialismus.library.guice.TypeLiteral;
import me.whereareiam.socialismus.library.guice.name.Names;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.Announcement;
import me.whereareiam.socialismus.module.chirper.api.model.announcer.Announcer;
import me.whereareiam.socialismus.module.chirper.api.model.config.ChirperCommands;
import me.whereareiam.socialismus.module.chirper.api.model.config.ChirperMessages;
import me.whereareiam.socialismus.module.chirper.configuration.provider.AnnouncementsProvider;
import me.whereareiam.socialismus.module.chirper.configuration.provider.AnnouncersProvider;
import me.whereareiam.socialismus.module.chirper.configuration.provider.ChirperCommandsProvider;
import me.whereareiam.socialismus.module.chirper.configuration.provider.ChirperMessagesProvider;

public class ConfigBinder
extends AbstractModule {
    private final Path workingPath;
    private final Path announcementsPath;
    private final Path announcersPath;

    public ConfigBinder(Path workingDirectory) {
        this.workingPath = workingDirectory;
        this.announcementsPath = workingDirectory.resolve("announcements");
        this.announcersPath = workingDirectory.resolve("announcers");
    }

    protected void configure() {
        this.bind(Path.class).annotatedWith((Annotation)Names.named((String)"workingPath")).toInstance((Object)this.workingPath);
        this.bind(Path.class).annotatedWith((Annotation)Names.named((String)"announcementsPath")).toInstance((Object)this.announcementsPath);
        this.bind(Path.class).annotatedWith((Annotation)Names.named((String)"announcersPath")).toInstance((Object)this.announcersPath);
        this.createDirectories();
        this.bind(AnnouncementsProvider.class).asEagerSingleton();
        this.bind((TypeLiteral)new TypeLiteral<List<Announcement>>(){}).toProvider(AnnouncementsProvider.class);
        this.bind(AnnouncersProvider.class).asEagerSingleton();
        this.bind((TypeLiteral)new TypeLiteral<List<Announcer>>(){}).toProvider(AnnouncersProvider.class);
        this.bind(ChirperCommandsProvider.class).asEagerSingleton();
        this.bind(ChirperCommands.class).toProvider(ChirperCommandsProvider.class);
        this.bind(ChirperMessagesProvider.class).asEagerSingleton();
        this.bind(ChirperMessages.class).toProvider(ChirperMessagesProvider.class);
    }

    private void createDirectories() {
        try {
            Files.createDirectories(this.workingPath, new FileAttribute[0]);
            Files.createDirectories(this.announcementsPath, new FileAttribute[0]);
            Files.createDirectories(this.announcersPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create directories", e);
        }
    }
}

