/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.module.chirper.configuration.deserializer;

import java.io.IOException;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.jackson.core.JsonParser;
import me.whereareiam.socialismus.library.jackson.core.ObjectCodec;
import me.whereareiam.socialismus.library.jackson.core.TreeNode;
import me.whereareiam.socialismus.library.jackson.databind.DeserializationContext;
import me.whereareiam.socialismus.library.jackson.databind.JsonDeserializer;
import me.whereareiam.socialismus.library.jackson.databind.JsonNode;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.AnnouncementContent;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.variant.ActionbarAnnouncement;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.variant.BossBarAnnouncement;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.variant.MessageAnnouncement;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.variant.SoundAnnouncement;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.variant.TitleAnnouncement;

@Singleton
public class AnnouncementDeserializer
extends JsonDeserializer<AnnouncementContent> {
    public AnnouncementContent deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = parser.getCodec();
        JsonNode root = (JsonNode)codec.readTree(parser);
        if (root.has("message") && root.has("overlay") && root.has("color")) {
            return (AnnouncementContent)codec.treeToValue((TreeNode)root, BossBarAnnouncement.class);
        }
        if (root.has("message") && root.get("message").isArray()) {
            return (AnnouncementContent)codec.treeToValue((TreeNode)root, MessageAnnouncement.class);
        }
        if (root.has("title") && root.has("subtitle")) {
            return (AnnouncementContent)codec.treeToValue((TreeNode)root, TitleAnnouncement.class);
        }
        if (root.has("message")) {
            return (AnnouncementContent)codec.treeToValue((TreeNode)root, ActionbarAnnouncement.class);
        }
        if (root.has("sound")) {
            return (AnnouncementContent)codec.treeToValue((TreeNode)root, SoundAnnouncement.class);
        }
        return null;
    }
}

