/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.module.chirper.configuration.provider;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.Reloadable;
import me.whereareiam.socialismus.api.input.registry.ObjectMapperRegistry;
import me.whereareiam.socialismus.api.input.registry.Registry;
import me.whereareiam.socialismus.api.output.DefaultConfig;
import me.whereareiam.socialismus.api.output.config.ConfigurationLoader;
import me.whereareiam.socialismus.api.output.config.ConfigurationManager;
import me.whereareiam.socialismus.api.type.ConfigurationType;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.guice.name.Named;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.Announcement;
import me.whereareiam.socialismus.module.chirper.api.model.announcement.AnnouncementContent;
import me.whereareiam.socialismus.module.chirper.configuration.deserializer.AnnouncementDeserializer;
import me.whereareiam.socialismus.module.chirper.configuration.dynamic.AnnouncementsConfig;
import me.whereareiam.socialismus.module.chirper.configuration.template.AnnouncementTemplate;

@Singleton
public class AnnouncementsProvider
implements Provider<List<Announcement>>,
Reloadable {
    private final Path announcementsPath;
    private final ConfigurationLoader configLoader;
    private final ConfigurationType configurationType;
    private List<Announcement> announcements;

    @Inject
    public AnnouncementsProvider(@Named(value="announcementsPath") Path announcementsPath, ConfigurationLoader configLoader, ConfigurationManager configManager, ObjectMapperRegistry objectMapperRegistry, AnnouncementTemplate template, AnnouncementDeserializer contentDeserializer, Registry<Reloadable> registry) {
        this.announcementsPath = announcementsPath;
        this.configLoader = configLoader;
        this.configurationType = configManager.getConfigurationType();
        configManager.addTemplate(AnnouncementsConfig.class, (DefaultConfig)template);
        objectMapperRegistry.addDeserializer(AnnouncementContent.class, (Object)contentDeserializer);
        registry.register((Object)this);
    }

    public List<Announcement> get() {
        if (this.announcements != null) {
            return this.announcements;
        }
        this.loadAnnouncements();
        return this.announcements;
    }

    public void reload() {
        this.loadAnnouncements();
    }

    private void loadAnnouncements() {
        this.announcements = new ArrayList<Announcement>();
        try (Stream<Path> paths = Files.list(this.announcementsPath);){
            paths.filter(path -> path.getFileName().toString().endsWith(this.configurationType.getExtension())).forEach(path -> {
                String fileName = path.getFileName().toString().replace(this.configurationType.getExtension(), "");
                if (Files.isDirectory(path, new LinkOption[0]) || fileName.isEmpty()) {
                    return;
                }
                this.announcements.addAll(this.addAnnouncementsFromConfig(path.getParent().resolve(fileName)));
            });
        }
        catch (IOException e) {
            Logger.severe((String)"Failed to load announcement configurations", (Object[])new Object[]{e});
            this.announcements = Collections.emptyList();
            return;
        }
        if (this.announcements.isEmpty()) {
            this.announcements.addAll(this.addAnnouncementsFromConfig(this.announcementsPath.resolve("default")));
        }
        this.announcements.removeIf(announcement -> this.announcements.stream().anyMatch(c -> c != announcement && c.getId().equals(announcement.getId())));
    }

    private List<Announcement> addAnnouncementsFromConfig(Path path) {
        AnnouncementsConfig announcementsConfig = (AnnouncementsConfig)this.configLoader.load(path, AnnouncementsConfig.class);
        return announcementsConfig.getAnnouncements().stream().filter(Announcement::isEnabled).toList();
    }
}

