/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.module.chirper.configuration.provider;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.Reloadable;
import me.whereareiam.socialismus.api.input.registry.Registry;
import me.whereareiam.socialismus.api.output.DefaultConfig;
import me.whereareiam.socialismus.api.output.config.ConfigurationLoader;
import me.whereareiam.socialismus.api.output.config.ConfigurationManager;
import me.whereareiam.socialismus.api.type.ConfigurationType;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.guice.name.Named;
import me.whereareiam.socialismus.module.chirper.api.model.announcer.Announcer;
import me.whereareiam.socialismus.module.chirper.configuration.dynamic.AnnouncersConfig;
import me.whereareiam.socialismus.module.chirper.configuration.template.AnnouncerTemplate;

@Singleton
public class AnnouncersProvider
implements Provider<List<Announcer>>,
Reloadable {
    private final Path announcersPath;
    private final ConfigurationLoader configLoader;
    private final ConfigurationType configurationType;
    private List<Announcer> announcers;

    @Inject
    public AnnouncersProvider(@Named(value="announcersPath") Path announcersPath, ConfigurationLoader configLoader, ConfigurationManager configManager, AnnouncerTemplate template, Registry<Reloadable> registry) {
        this.announcersPath = announcersPath;
        this.configLoader = configLoader;
        this.configurationType = configManager.getConfigurationType();
        configManager.addTemplate(AnnouncersConfig.class, (DefaultConfig)template);
        registry.register((Object)this);
    }

    public List<Announcer> get() {
        if (this.announcers != null) {
            return this.announcers;
        }
        this.loadAnnouncers();
        return this.announcers;
    }

    public void reload() {
        this.loadAnnouncers();
    }

    private void loadAnnouncers() {
        this.announcers = new ArrayList<Announcer>();
        try (Stream<Path> paths = Files.list(this.announcersPath);){
            paths.filter(path -> path.getFileName().toString().endsWith(this.configurationType.getExtension())).forEach(path -> {
                String fileName = path.getFileName().toString().replace(this.configurationType.getExtension(), "");
                if (Files.isDirectory(path, new LinkOption[0]) || fileName.isEmpty()) {
                    return;
                }
                this.announcers.addAll(this.addAnnouncersFromConfig(path.getParent().resolve(fileName)));
            });
        }
        catch (IOException e) {
            Logger.severe((String)"Failed to load announcers configurations", (Object[])new Object[]{e});
            this.announcers = Collections.emptyList();
            return;
        }
        if (this.announcers.isEmpty()) {
            this.announcers.addAll(this.addAnnouncersFromConfig(this.announcersPath.resolve("default")));
        }
        this.announcers.removeIf(announcer -> this.announcers.stream().anyMatch(c -> c != announcer));
    }

    private List<Announcer> addAnnouncersFromConfig(Path path) {
        AnnouncersConfig announcersConfig = (AnnouncersConfig)this.configLoader.load(path, AnnouncersConfig.class);
        return announcersConfig.getAnnouncers().stream().filter(Announcer::isEnabled).toList();
    }
}

