/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.module.chirper.configuration.provider;

import java.nio.file.Path;
import me.whereareiam.socialismus.api.Reloadable;
import me.whereareiam.socialismus.api.input.registry.Registry;
import me.whereareiam.socialismus.api.output.DefaultConfig;
import me.whereareiam.socialismus.api.output.config.ConfigurationLoader;
import me.whereareiam.socialismus.api.output.config.ConfigurationManager;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.guice.name.Named;
import me.whereareiam.socialismus.module.chirper.api.model.config.ChirperCommands;
import me.whereareiam.socialismus.module.chirper.configuration.template.ChirperCommandsTemplate;

@Singleton
public class ChirperCommandsProvider
implements Provider<ChirperCommands>,
Reloadable {
    private final Path workingPath;
    private final ConfigurationLoader configLoader;
    private ChirperCommands commands;

    @Inject
    public ChirperCommandsProvider(@Named(value="workingPath") Path workingPath, ConfigurationLoader configLoader, ConfigurationManager configManager, ChirperCommandsTemplate template, Registry<Reloadable> reloadableRegistry) {
        this.workingPath = workingPath;
        this.configLoader = configLoader;
        configManager.addTemplate(ChirperCommands.class, (DefaultConfig)template);
        reloadableRegistry.register((Object)this);
        this.get();
    }

    public ChirperCommands get() {
        if (this.commands != null) {
            return this.commands;
        }
        this.load();
        return this.commands;
    }

    public void reload() {
        this.load();
    }

    private void load() {
        this.commands = (ChirperCommands)this.configLoader.load(this.workingPath.resolve("commands"), ChirperCommands.class);
    }
}

